/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.core.UserNotifier;
import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.ActorConfigBoolean;
import edu.uchc.connjur.wb.ActorElement;
import edu.uchc.connjur.wb.Checkpoint;
import edu.uchc.connjur.wb.Config;
import edu.uchc.connjur.wb.ExecutionTrace;
import edu.uchc.connjur.wb.Flag;
import edu.uchc.connjur.wb.LineStringBuilder;
import edu.uchc.connjur.wb.NodeForActor;
import edu.uchc.connjur.wb.ResultStatus;
import edu.uchc.connjur.wb.annotation.ConfigEditor;
import edu.uchc.connjur.wb.event.ActorEvent;
import edu.uchc.connjur.wb.event.ActorListener;
import edu.uchc.connjur.wb.event.EventFilter;
import edu.uchc.connjur.wb.gui.ActorConfigurationEntry;
import edu.uchc.connjur.wb.gui.ColorCatalog;
import edu.uchc.connjur.wb.gui.ConfigEdit;
import edu.uchc.connjur.wb.gui.ConfigEditPanel;
import edu.uchc.connjur.wb.gui.ConfigFilename;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.Header;
import edu.uchc.connjur.wb.gui.WorkflowBuilder;
import edu.uchc.connjur.wb.gui.component.ExceptionDialog;
import edu.uchc.connjur.wb.gui.component.HTMLButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ActorConfigurationEditor
extends JDialog
implements ConfigEditPanel.ConfigEditClient,
ActorListener {
    public static int LINGER_TIME = 5000;
    private JPanel buttonPanel;
    private JButton okButton;
    private JPanel mainBottomPanel;
    private JTextArea statusArea;
    private JTextArea messageArea;
    private JButton infoButton;
    private JButton helpButton;
    private JButton cancelButton;
    private JButton bypassButton;
    private JButton exceptionButton;
    private JPanel configEditPane;
    private Exception lastException;
    private boolean canClose = true;
    private int baselineHeight;
    private ActorElement actorElement;
    private Checkpoint checkpoint;
    private Vector<ActorConfigurationEntry> edits;
    private Component client;
    private ActorConfigBoolean verifyEdit = null;
    private EventFilter<ActorEvent, ActorListener> engine;
    private UserUpdater updater = null;
    private NodeForActor nodeForActor;
    private static GraphicLogger lg = GraphicLogger.getLogger(ActorConfigurationEditor.class);
    private static Set<Provider> providers = new HashSet<Provider>();

    public ActorConfigurationEditor(Frame owner, Component client) {
        super(owner, "Actor Configuration", true);
        this.client = client;
        this.initGUI();
        this.pack();
        this.baselineHeight = this.getHeight();
        this.engine = new EventFilter();
        this.engine.addListener((EventListener)((Object)this));
        this.addWindowListener(new CloseMonitor());
    }

    private void initGUI() {
        try {
            Container main = this.getContentPane();
            main.setLayout(new BorderLayout());
            this.configEditPane = new JPanel();
            BoxLayout configEditPaneLayout = new BoxLayout(this.configEditPane, 1);
            this.configEditPane.setLayout(configEditPaneLayout);
            main.add((Component)this.configEditPane, "Center");
            this.mainBottomPanel = new JPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.mainBottomPanel.setLayout(jPanel1Layout);
            main.add((Component)this.mainBottomPanel, "South");
            this.buttonPanel = new JPanel();
            BoxLayout bl = new BoxLayout(this.buttonPanel, 1);
            this.buttonPanel.setLayout(bl);
            JPanel topButtonRow = new JPanel();
            JPanel bottomButtonRow = new JPanel();
            this.buttonPanel.add(topButtonRow);
            this.buttonPanel.add(bottomButtonRow);
            this.mainBottomPanel.add((Component)this.buttonPanel, "South");
            this.okButton = new JButton();
            bottomButtonRow.add(this.okButton);
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActorConfigurationEditor.this.ok();
                }
            });
            this.cancelButton = new JButton();
            bottomButtonRow.add(this.cancelButton);
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActorConfigurationEditor.this.cancel();
                }
            });
            this.infoButton = new JButton("Info");
            topButtonRow.add(this.infoButton);
            this.infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActorConfigurationEditor.this.showInfo();
                }
            });
            this.exceptionButton = new HTMLButton("<html>Error<br>Detail</html>");
            this.exceptionButton.setEnabled(false);
            topButtonRow.add(this.exceptionButton);
            this.exceptionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActorConfigurationEditor.this.showExceptionDialog();
                }
            });
            this.helpButton = new HTMLButton("<html>Online<br>help</html>");
            topButtonRow.add(this.helpButton);
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActorConfigurationEditor.this.callHelp();
                }
            });
            HTMLButton wikiButton = new HTMLButton("<html>Online<br>wiki</html>");
            topButtonRow.add(wikiButton);
            wikiButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActorConfigurationEditor.this.callWiki();
                }
            });
            this.bypassButton = new HTMLButton("<html>Bypass<br>actor</html>");
            topButtonRow.add(this.bypassButton);
            this.bypassButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActorConfigurationEditor.this.doBypass(evt);
                }
            });
            this.statusArea = new JTextArea();
            this.mainBottomPanel.add((Component)this.statusArea, "North");
            this.statusArea.setText("s");
            this.statusArea.setBackground(Color.WHITE);
            this.messageArea = new JTextArea(" ");
            this.messageArea.setBackground(ColorCatalog.get().get(ColorCatalog.Item.EDITOR_BACKGROUND));
            Dimension d = this.messageArea.getPreferredSize();
            d.width = 0;
            d.height *= 3;
            JScrollPane statusScroll = new JScrollPane(this.messageArea);
            statusScroll.setPreferredSize(d);
            this.mainBottomPanel.add((Component)statusScroll, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register(Provider p) {
        providers.add(p);
    }

    public static ActorConfigurationEntry getMostAppropriate(Config c, ConfigEditPanel.ConfigEditClient client) {
        try {
            Actor ab = c.getActor();
            ConfigEditor ceAnnotation = (ConfigEditor)ab.getFieldAnnotation(c.getName(), ConfigEditor.class);
            if (ceAnnotation != null) {
                for (Provider p : providers) {
                    ActorConfigurationEntry ace = p.supports(ceAnnotation, c, client);
                    if (ace == null) continue;
                    return ace;
                }
            }
            return new ConfigEdit(c, client);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void ok() {
        ResultStatus rs;
        if (!this.canClose) {
            return;
        }
        if (this.verifyEdit != null && !(rs = this.verifyEdit.setValue(Boolean.valueOf(true))).isGood()) {
            this.setStatusText(rs.getMessage(), true);
            return;
        }
        Actor actor = this.actorElement.getActor();
        if (this.checkpoint != null && this.checkpoint.isModified()) {
            actor.notifyListeners(ActorEvent.Reason.CONFIG_CHANGE);
        }
        this.setVisible(false);
        Cursor oldCursor = this.client.getCursor();
        this.client.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(new DeferredSender(actor, this.engine, oldCursor, false));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.canClose = true;
        } else {
            this.actorElement.getActor().removeActorListener((ActorListener)this);
            UserNotifier.getInstance().removeProtocol((UserNotifier.NotificationProtocol)this.updater);
        }
        super.setVisible(visible);
    }

    private void cancel() {
        if (this.checkpoint != null) {
            this.checkpoint.rollback();
            this.checkpoint = null;
        }
        this.actorElement.getActor().useDefaultNotificationEngine();
        this.engine.discardEvents();
        this.setVisible(false);
    }

    private void setInfoState() {
        Actor actor = this.actorElement.getActor();
        String info = actor.getLastRunCommand();
        boolean haveStuff = info != null && info.trim().length() > 0;
        boolean hasRun = actor.getProcessState() == Actor.ProcessState.COMPLETE || actor.getStatus() == Actor.Status.FAIL;
        this.infoButton.setEnabled(haveStuff && hasRun);
    }

    private void showInfo() {
        String info = this.actorElement.getActor().getLastRunCommand();
        JOptionPane.showMessageDialog(this, info, "Last Run Commands", 1);
    }

    private void callHelp() {
        String url = this.actorElement.getActor().helpUrl();
        assert (url != null) : "help button enabled inappropriate time";
        WorkflowBuilder.openURL(url);
    }

    private void callWiki() {
        String url;
        String className = ExecutionTrace.justClassName((Object)this.actorElement.getActor());
        String splitClassName = ConfigEditPanel.splitCamelCase(className);
        try {
            url = "http://www.connjur.com/wiki/" + URLEncoder.encode(splitClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            url = "http://www.connjur.com/wiki/" + className;
        }
        WorkflowBuilder.openURL(url);
    }

    private void showExceptionDialog() {
        assert (this.lastException != null);
        new ExceptionDialog(this.lastException, false);
    }

    public void setActorElement(ActorElement actorElement, NodeForActor nfa) {
        this.verifyEdit = null;
        ActorElement sqr = actorElement;
        if (actorElement != null) {
            actorElement.getActor().removeActorListener((ActorListener)this);
        }
        this.actorElement = sqr;
        this.nodeForActor = nfa;
        this.checkpoint = new Checkpoint(sqr);
        Actor actor = actorElement.getActor();
        boolean canBypass = nfa != null && nfa.canBypass();
        this.bypassButton.setEnabled(canBypass);
        actor.setNotificationEngine(this.engine);
        if (actor.getStatus() != Actor.Status.FAIL) {
            this.setStatusText("", false);
        } else {
            this.setStatusText("Error: " + actor.errorMsg(), true);
        }
        this.setLastException(actor.lastException());
        super.setTitle(actor.getDescription());
        this.configEditPane.removeAll();
        this.edits = new Vector();
        Header header = new Header(this);
        header.setVisible(true);
        this.configEditPane.add(header);
        this.edits.add(header);
        for (int i = 0; i < 6; ++i) {
            for (Config cfg : sqr.getConfigs(i)) {
                Flag flag = cfg.flags();
                if (flag.isSet(2L)) {
                    assert (this.verifyEdit == null);
                    this.verifyEdit = (ActorConfigBoolean)cfg;
                }
                if (flag.isSet(8L)) continue;
                ActorConfigurationEntry ace = ActorConfigurationEditor.getMostAppropriate(cfg, this);
                Component aceComp = (Component)((Object)ace);
                aceComp.setVisible(true);
                this.configEditPane.add(aceComp);
                this.edits.add(ace);
            }
        }
        actor.addActorListener((ActorListener)this);
        int idWidth = 0;
        int editWidth = 0;
        int infoWidth = 0;
        int unitsWidth = 0;
        int aceHeight = 0;
        for (ActorConfigurationEntry ce : this.edits) {
            aceHeight += (int)ce.getSelf().getPreferredSize().getHeight();
            idWidth = Math.max(idWidth, (int)ce.getTitle().getPreferredSize().getWidth());
            editWidth = Math.max(idWidth, (int)ce.getEdit().getPreferredSize().getWidth());
            infoWidth = Math.max(idWidth, (int)ce.getInfo().getPreferredSize().getWidth());
            unitsWidth = Math.max(unitsWidth, (int)ce.getUnits().getPreferredSize().getWidth());
        }
        if (lg.isInfoEnabled()) {
            lg.graphics("id width " + idWidth);
        }
        Dimension titleDim = new Dimension(idWidth, 0);
        Dimension editDim = new Dimension(editWidth, 0);
        Dimension infoDim = new Dimension(infoWidth, 0);
        Dimension unitsDim = new Dimension(unitsWidth, 0);
        for (ActorConfigurationEntry ce : this.edits) {
            ce.getTitle().setPreferredSize(titleDim);
            ce.getEdit().setPreferredSize(editDim);
            ce.getInfo().setPreferredSize(infoDim);
            ce.getUnits().setPreferredSize(unitsDim);
        }
        int totalWidth = Math.max(500, idWidth + editWidth + infoWidth + unitsWidth);
        Dimension ds = new Dimension(totalWidth, this.baselineHeight + aceHeight);
        this.setPreferredSize(ds);
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent event) {
                ActorConfigurationEditor.this.checkWindowState(event);
            }
        });
        boolean helpAvailable = actor.helpUrl() != null;
        this.helpButton.setEnabled(helpAvailable);
        this.updater = new UserUpdater();
        UserNotifier.getInstance().replaceProtocols((UserNotifier.NotificationProtocol)this.updater);
        this.messageArea.setText("");
        this.setInfoState();
        this.setSize(ds);
        this.invalidate();
    }

    public void actorChanged(ActorEvent event) {
        switch (event.getReason()) {
            case STATE_CHANGE: {
                this.setInfoState();
            }
            case CONFIG_CHANGE: 
            case DATA_HAS_CHANGED: {
                for (ActorConfigurationEntry ace : this.edits) {
                    ace.refresh();
                }
                break;
            }
            case DATA_IDENTIFICATION_CHANGE: 
            case DATA_ELEMENT_CREATED: 
            case DELETED: {
                break;
            }
            case BYPASSED: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void setResult(ResultStatus resultStatus) {
        if (this.updater != null) {
            this.updater.clearMessage();
        }
        this.canClose = resultStatus.isGood();
        this.okButton.setEnabled(this.canClose);
        if (this.canClose) {
            this.setStatusText("", false);
        } else {
            this.setStatusText(resultStatus.getMessage(), true);
            this.setLastException(resultStatus.getException());
        }
        this.pack();
    }

    private void setLastException(Exception e) {
        this.lastException = e;
        boolean isSet = this.lastException != null;
        this.exceptionButton.setEnabled(isSet);
    }

    private void checkWindowState(WindowEvent evt) {
        if (lg.isInfoEnabled()) {
            lg.graphics("this.windowDeactivated, event=" + evt);
        }
        if (this.isVisible()) {
            return;
        }
        this.actorElement.checkConfigStatus();
        if (this.updater != null) {
            UserNotifier.getInstance().removeProtocol((UserNotifier.NotificationProtocol)this.updater);
            this.updater = null;
        }
        this.actorElement.getActor().removeActorListener((ActorListener)this);
    }

    private void setStatusText(String text, boolean isError) {
        this.statusArea.setForeground(isError ? Color.RED : Color.BLACK);
        this.statusArea.setText(text);
        this.pack();
    }

    private void doBypass(ActionEvent evt) {
        assert (this.nodeForActor != null);
        this.setVisible(false);
        Cursor oldCursor = this.client.getCursor();
        this.client.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(new DeferredSender(this.nodeForActor.getActor(), this.engine, oldCursor, true));
    }

    static {
        ConfigFilename.init();
    }

    private class DeferredSender
    implements Runnable {
        Actor actor;
        EventFilter<ActorEvent, ActorListener> filter;
        Cursor cursor;
        private boolean bypassActor;

        public DeferredSender(Actor actor, EventFilter<ActorEvent, ActorListener> filter, Cursor cursor, boolean bypassActor) {
            this.actor = actor;
            this.filter = filter;
            this.cursor = cursor;
            this.bypassActor = bypassActor;
        }

        @Override
        public void run() {
            this.actor.useDefaultNotificationEngine();
            this.filter.sendDeferred();
            if (this.bypassActor) {
                assert (ActorConfigurationEditor.this.nodeForActor != null);
                ActorConfigurationEditor.this.nodeForActor.setBypassed();
            }
            ActorConfigurationEditor.this.client.setCursor(this.cursor);
        }
    }

    private class UserUpdater
    implements UserNotifier.NotificationProtocol {
        long lastTime = 0L;
        int clearCount = 0;
        LineStringBuilder lsb = new LineStringBuilder();
        Timer clearTimer = new Timer(LINGER_TIME, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorConfigurationEditor.this.messageArea.setText("");
            }
        });

        private UserUpdater() {
        }

        public void clearMessage() {
            if (this.clearCount-- > 0) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastTime > (long)LINGER_TIME) {
                ActorConfigurationEditor.this.messageArea.setText(" ");
                return;
            }
            this.clearTimer.start();
        }

        public void tellUser(String message) {
            this.clearTimer.stop();
            this.clearCount = 1;
            ActorConfigurationEditor.this.messageArea.setPreferredSize(null);
            long now = System.currentTimeMillis();
            this.lsb.clear();
            if (now - this.lastTime < (long)LINGER_TIME) {
                this.lsb.write(ActorConfigurationEditor.this.messageArea.getText());
            }
            this.lsb.append(message);
            ActorConfigurationEditor.this.messageArea.setText(this.lsb.toString());
            this.lastTime = now;
        }
    }

    private class CloseMonitor
    extends WindowAdapter {
        private CloseMonitor() {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            ActorConfigurationEditor.this.cancel();
        }
    }

    public static interface Provider {
        public ActorConfigurationEntry supports(ConfigEditor var1, Config var2, ConfigEditPanel.ConfigEditClient var3);
    }
}

