/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.ActorElement;
import edu.uchc.connjur.wb.NodeForActor;
import edu.uchc.connjur.wb.WorkflowNode;
import edu.uchc.connjur.wb.actor.DisplayActor;
import edu.uchc.connjur.wb.actor.NoDataElementOutput;
import edu.uchc.connjur.wb.event.ActorEvent;
import edu.uchc.connjur.wb.event.ActorListener;
import edu.uchc.connjur.wb.gui.ActorConfigurationEditor;
import edu.uchc.connjur.wb.gui.ColorCatalog;
import edu.uchc.connjur.wb.gui.ElementVisual;
import edu.uchc.connjur.wb.gui.WorkflowCanvas;
import edu.uchc.connjur.wb.st.FileSystemLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ActorVisual
extends ElementVisual
implements ActorListener {
    private static Polygon diamondShape = new DiamondShape();
    private static Polygon rightArrowShape = new RightArrowShape();
    private static Polygon leftArrowShape = new LeftArrowShape();
    private static Shape circleShape = new CircleShape();
    protected Actor actor;
    protected ActorVisualRepresentation ourVisual;
    protected Font ourFont = null;
    protected float textOffset;

    public ActorVisual(WorkflowNode node, WorkflowCanvas owner) {
        super(node, owner);
        ActorElement ae = (ActorElement)node.getWorkflowElement();
        this.actor = ae.getActor();
        this.actor.addActorListener((ActorListener)this);
        this.construct();
    }

    private final void construct() {
        this.flowInX = -STANDARD_WIDTH / 2;
        this.flowOutX = STANDARD_WIDTH / 2;
        if (this.actor instanceof FileSystemLoader) {
            this.ourVisual = new RightArrow();
            return;
        }
        if (this.actor instanceof DisplayActor) {
            this.ourVisual = new Circle();
            return;
        }
        if (this.actor instanceof NoDataElementOutput) {
            this.ourVisual = new LeftArrow();
            return;
        }
        this.ourVisual = new Diamond();
    }

    @Override
    protected int maxTextWidthForHeight(int height) {
        return this.ourVisual.maxTextWidthForHeight(height);
    }

    @Override
    protected Point topLeftOfText(Rectangle2D rectangle) {
        return this.ourVisual.topLeftOfText(rectangle);
    }

    @Override
    protected String getDescription() {
        if (this.actor != null) {
            return this.actor.getCurrentDescription();
        }
        return "Unintialized Actor";
    }

    @Override
    int getHeight() {
        return STANDARD_HEIGHT;
    }

    @Override
    int getWidth() {
        return STANDARD_WIDTH;
    }

    @Override
    public boolean inside(int x, int y) {
        if (lg.isDebugEnabled()) {
            lg.graphics("testing for click at " + x + "," + y + " for actor" + this.actor.getDescription());
        }
        return this.ourVisual.getShape().contains(x, y);
    }

    @Override
    public void setX(int x) {
        super.setX(x);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
    }

    @Override
    public void setNode(WorkflowNode node) {
        super.setNode(node);
        this.actor = (Actor)node.getWorkflowElement();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.owner.getScale() < 1.0) {
            this.owner.setToolTipText(this.actor.getCurrentDescription());
        }
    }

    @Override
    public void mouseLeft() {
        this.owner.setToolTipText(null);
    }

    @Override
    protected BufferedImage buildImage(Graphics2D g) {
        double scale = this.owner.getScale();
        int h = (int)((double)STANDARD_HEIGHT * scale);
        int w = (int)((double)STANDARD_WIDTH * scale);
        this.ourImage = g.getDeviceConfiguration().createCompatibleImage(w, h, 2);
        Shape ourShape = this.owner.scaled(this.ourVisual.getShape());
        Graphics2D imgG = this.ourImage.createGraphics();
        Color c = colorCatalog.actorImage(this.actor);
        imgG.setColor(c);
        imgG.fill(ourShape);
        imgG.setColor(Color.BLACK);
        this.writeDescriptionLabel(imgG);
        imgG.setStroke(this.selectionStroke(this.selected));
        imgG.setColor(colorCatalog.get(ColorCatalog.Item.ACTOR_BORDER));
        imgG.draw(ourShape);
        return this.ourImage;
    }

    public void actorChanged(ActorEvent event) {
        super.invalidateImage();
        ActorEvent.Reason reason = event.getReason();
        switch (reason) {
            case DELETED: {
                this.owner.arrangeElements();
                break;
            }
            case BYPASSED: {
                this.actor = event.getActor();
            }
        }
    }

    @Override
    public void notifyClient(WorkflowCanvas.CanvasClient client, boolean exclusive, boolean single) {
        client.actorElementSelected((NodeForActor)this.node, exclusive, single);
    }

    @Override
    public void doubleClicked(JFrame windowOwner, int x, int y) {
        NodeForActor nfa = (NodeForActor)this.node;
        if (!nfa.isBypassed()) {
            ActorConfigurationEditor configurationEditor = new ActorConfigurationEditor((Frame)windowOwner, this.owner);
            configurationEditor.setActorElement(nfa.getActorElement(), nfa);
            configurationEditor.setLocation(x, y);
            configurationEditor.setVisible(true);
        } else {
            int rc = JOptionPane.showConfirmDialog(this.owner, "Restore " + this.actor.getDescription() + "?", "Remove bypass?", 0);
            if (rc == 0) {
                nfa.clearBypass();
            }
        }
    }

    private static class CircleShape
    extends Ellipse2D.Float {
        public CircleShape() {
            super(0.0f, 0.0f, ElementVisual.STANDARD_WIDTH, ElementVisual.STANDARD_HEIGHT);
        }
    }

    private static class LeftArrowShape
    extends Polygon {
        static int[] xpoints = new int[]{ElementVisual.STANDARD_WIDTH / 2 - 1, -ElementVisual.STANDARD_WIDTH / 2, ElementVisual.STANDARD_WIDTH / 2 - 1};
        static int[] ypoints = new int[]{-ElementVisual.STANDARD_HEIGHT / 2, 0, ElementVisual.STANDARD_HEIGHT / 2};
        static final int nPoints = 3;

        public LeftArrowShape() {
            super(xpoints, ypoints, 3);
            assert (xpoints.length == 3);
            assert (ypoints.length == 3);
            this.translate(ElementVisual.STANDARD_WIDTH / 2, ElementVisual.STANDARD_HEIGHT / 2);
        }
    }

    private static class RightArrowShape
    extends Polygon {
        static int[] xpoints = new int[]{-ElementVisual.STANDARD_WIDTH / 2, ElementVisual.STANDARD_WIDTH / 2, -ElementVisual.STANDARD_WIDTH / 2};
        static int[] ypoints = new int[]{-ElementVisual.STANDARD_HEIGHT / 2, 0, ElementVisual.STANDARD_HEIGHT / 2};
        static final int nPoints = 3;

        public RightArrowShape() {
            super(xpoints, ypoints, 3);
            assert (xpoints.length == 3);
            assert (ypoints.length == 3);
            this.translate(ElementVisual.STANDARD_WIDTH / 2, ElementVisual.STANDARD_HEIGHT / 2);
        }
    }

    private static class DiamondShape
    extends Polygon {
        static int[] xpoints = new int[]{0, ElementVisual.STANDARD_WIDTH / 2, 0, -ElementVisual.STANDARD_WIDTH / 2};
        static int[] ypoints = new int[]{-ElementVisual.STANDARD_HEIGHT / 2, 0, ElementVisual.STANDARD_HEIGHT / 2, 0};
        static final int nPoints = 4;

        public DiamondShape() {
            super(xpoints, ypoints, 4);
            assert (xpoints.length == 4);
            assert (ypoints.length == 4);
            this.translate(ElementVisual.STANDARD_WIDTH / 2, ElementVisual.STANDARD_HEIGHT / 2);
        }
    }

    private class LeftArrow
    implements ActorVisualRepresentation {
        public LeftArrow() {
            ActorVisual.this.justification = ElementVisual.TextJustification.RIGHT;
        }

        @Override
        public int maxTextWidthForHeight(int height) {
            return ElementVisual.STANDARD_WIDTH - height - ElementVisual.MARGIN;
        }

        @Override
        public Point topLeftOfText(Rectangle2D rectangle) {
            int x = (int)((double)ActorVisual.this.getWidth() - rectangle.getWidth()) - ElementVisual.MARGIN;
            int y = (int)(((double)ActorVisual.this.getHeight() - rectangle.getHeight()) / 2.0);
            return new Point(x, y);
        }

        @Override
        public Polygon getShape() {
            return leftArrowShape;
        }
    }

    private class RightArrow
    implements ActorVisualRepresentation {
        public RightArrow() {
            ActorVisual.this.justification = ElementVisual.TextJustification.LEFT;
        }

        @Override
        public int maxTextWidthForHeight(int height) {
            return ElementVisual.STANDARD_WIDTH - height - ElementVisual.MARGIN;
        }

        @Override
        public Point topLeftOfText(Rectangle2D rectangle) {
            int x = ElementVisual.MARGIN;
            int y = (int)(((double)ActorVisual.this.getHeight() - rectangle.getHeight()) / 2.0);
            return new Point(x, y);
        }

        @Override
        public Polygon getShape() {
            return rightArrowShape;
        }
    }

    private class Circle
    extends Diamond {
        private Circle() {
        }

        @Override
        public Shape getShape() {
            return circleShape;
        }
    }

    private class Diamond
    implements ActorVisualRepresentation {
        public Diamond() {
            ActorVisual.this.justification = ElementVisual.TextJustification.CENTER;
        }

        @Override
        public int maxTextWidthForHeight(int height) {
            assert (ElementVisual.STANDARD_WIDTH == ElementVisual.STANDARD_HEIGHT) : "layout boxes assumed to be square";
            return ElementVisual.STANDARD_WIDTH - height;
        }

        @Override
        public Point topLeftOfText(Rectangle2D rectangle) {
            int x = (int)(((double)ActorVisual.this.getWidth() - rectangle.getWidth()) / 2.0);
            int y = (int)(((double)ActorVisual.this.getHeight() - rectangle.getHeight()) / 2.0);
            return new Point(x, y);
        }

        @Override
        public Shape getShape() {
            return diamondShape;
        }
    }

    private static interface ActorVisualRepresentation {
        public int maxTextWidthForHeight(int var1);

        public Point topLeftOfText(Rectangle2D var1);

        public Shape getShape();
    }
}

