/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.Config;
import edu.uchc.connjur.wb.DataElement;
import edu.uchc.connjur.wb.Portfolio;
import edu.uchc.connjur.wb.annotation.Required;
import java.awt.Color;
import java.util.prefs.Preferences;

public class ColorCatalog {
    private Color[] itemColors = new Color[Item.values().length];
    private Preferences node = null;

    public static ColorCatalog get() {
        return Holder.INSTANCE;
    }

    private ColorCatalog() {
        this.setup();
    }

    private void setup() {
        this.node = Preferences.userNodeForPackage(ColorCatalog.class);
        this.setFromPreferences(Item.FAIL, Color.RED);
        this.setFromPreferences(Item.NOT_CONFIGURED, Color.MAGENTA);
        this.setFromPreferences(Item.WAITING_START, Color.PINK);
        this.setFromPreferences(Item.IN_PROGRESS, Color.CYAN);
        this.setFromPreferences(Item.COMPLETE, Color.GREEN);
        this.setFromPreferences(Item.NO_TOOL, Color.LIGHT_GRAY);
        this.setFromPreferences(Item.BYPASSED, Color.WHITE);
        this.setFromPreferences(Item.ACTOR_BORDER, Color.BLACK);
        this.setFromPreferences(Item.DATA_PRESENT, Color.GREEN);
        this.setFromPreferences(Item.DATA_NOT_PRESENT, Color.PINK);
        this.setFromPreferences(Item.DATA_VIRTUAL, Color.LIGHT_GRAY);
        this.setFromPreferences(Item.POPUP_BACKGROUND, new Color(255, 255, 240));
        this.setFromPreferences(Item.POPUP_FOREGROUND, Color.BLACK);
        this.setFromPreferences(Item.EDITOR_BACKGROUND, new Color(204, 255, 102));
    }

    private void setFromPreferences(Item item, Color defaultColor) {
        this.itemColors[item.ordinal()] = defaultColor;
        int defaultCode = defaultColor.getRGB();
        String defaultString = Integer.toString(defaultCode);
        String s = this.node.get(item.name(), defaultString);
        try {
            Color c;
            int colorCode = Integer.parseInt(s);
            this.itemColors[item.ordinal()] = c = new Color(colorCode);
        }
        catch (NumberFormatException nfe) {
            this.node.put(item.name(), defaultString);
        }
    }

    public void setPreference(Item item, Color color) {
        this.node = Preferences.userNodeForPackage(ColorCatalog.class);
        String code = Integer.toString(color.getRGB());
        this.node.put(item.name(), code);
        this.itemColors[item.ordinal()] = color;
    }

    public void restoreDefaults() {
        this.node = Preferences.userNodeForPackage(ColorCatalog.class);
        for (Item i : Item.values()) {
            this.node.remove(i.name());
        }
        this.setup();
    }

    public Color get(Item i) {
        return this.itemColors[i.ordinal()];
    }

    public Color configLabel(Config config) {
        Actor ab = config.getActor();
        if (ab.getFieldAnnotation(config.getName(), Required.class) != null && config.getValue() == null) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    Color actorImage(Actor ab) {
        if (ab.getStatus() == Actor.Status.FAIL) {
            return this.get(Item.FAIL);
        }
        switch (ab.getProcessState()) {
            case NOT_CONFIGURED: {
                return this.get(Item.NOT_CONFIGURED);
            }
            case WAITING_START: {
                if (ab.isToolInstalled()) {
                    return this.get(Item.WAITING_START);
                }
                return this.get(Item.NO_TOOL);
            }
            case IN_PROGRESS: {
                return this.get(Item.IN_PROGRESS);
            }
            case COMPLETE: {
                return this.get(Item.COMPLETE);
            }
            case BYPASSED: {
                return this.get(Item.BYPASSED);
            }
        }
        return Color.WHITE;
    }

    public Color portfolioImage(Portfolio portfolio) {
        DataElement de = portfolio.getAvailableCurrentDataElement();
        if (de != null) {
            if (de.isMetaDataOnly()) {
                return this.get(Item.DATA_NOT_PRESENT);
            }
            if (de.isVirtual()) {
                return this.get(Item.DATA_VIRTUAL);
            }
            return this.get(Item.DATA_PRESENT);
        }
        return this.get(Item.DATA_NOT_PRESENT);
    }

    public Color processColor(Actor.CanProcess cp) {
        switch (cp) {
            case SUPPORTED: {
                return Color.BLUE;
            }
            case NOT_RECOMMENDED: {
                return Color.RED;
            }
        }
        return Color.GRAY;
    }

    private static class Holder {
        private static ColorCatalog INSTANCE = new ColorCatalog();

        private Holder() {
        }
    }

    public static enum Item {
        NOT_CONFIGURED("Actor not configured"),
        WAITING_START("Actor waiting to start"),
        IN_PROGRESS("Actor processing in progress"),
        COMPLETE("Actor processing complete"),
        FAIL("Actor execution failed"),
        NO_TOOL("Actor whose external program is not installed"),
        BYPASSED("Bypassed Actors and Portfolios"),
        ACTOR_BORDER("Border of selected Actor"),
        DATA_PRESENT("Portfolio data present"),
        DATA_NOT_PRESENT("Portfolio data not present"),
        DATA_VIRTUAL("Data not required in Workflow Builder memory"),
        POPUP_BACKGROUND("Popup background (fids, runtime commands)"),
        POPUP_FOREGROUND("Popup foreground (fids, runtime commands)"),
        EDITOR_BACKGROUND("Editor background color");

        public final String description;

        private Item(String description) {
            this.description = description;
        }
    }
}

