/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.ActorFactory;
import edu.uchc.connjur.wb.NodeForPortfolio;
import edu.uchc.connjur.wb.actor.FlowActor;
import edu.uchc.connjur.wb.gui.ActorEntry;
import edu.uchc.connjur.wb.gui.ColorCatalog;
import java.awt.Color;
import java.awt.Component;
import java.beans.Beans;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboActorChooser
extends JComboBox
implements ListCellRenderer {
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private Color supportsColor = ColorCatalog.get().processColor(Actor.CanProcess.SUPPORTED);
    private Color notRecColor = ColorCatalog.get().processColor(Actor.CanProcess.NOT_RECOMMENDED);
    private NodeForPortfolio portfolioNode = null;

    public ComboActorChooser() {
        if (Beans.isDesignTime()) {
            this.model.addElement("Actor one");
            this.model.addElement("Actor two");
        }
        super.setModel(this.model);
        super.setRenderer(this);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = new JLabel();
        if (value != null) {
            label.setBackground(Color.WHITE);
            label.setText(value.toString());
            if (value instanceof ActorEntry) {
                ActorEntry ae = (ActorEntry)value;
                if (ae.isSupports()) {
                    label.setForeground(this.supportsColor);
                } else {
                    label.setForeground(this.notRecColor);
                }
            }
        }
        return label;
    }

    public void setSelected(NodeForPortfolio node) {
        this.portfolioNode = node;
        this.model.removeAllElements();
        ActorFactory.Actors actors = node.canAdd();
        for (FlowActor a : actors.supports) {
            this.model.addElement(new ActorEntry<FlowActor>(a, true));
        }
        for (FlowActor a : actors.notRecommended) {
            this.model.addElement(new ActorEntry<FlowActor>(a, false));
        }
    }

    public void clearSelected() {
        this.model.removeAllElements();
    }

    public FlowActor getSelectedActor() {
        ActorEntry ae = (ActorEntry)this.getSelectedItem();
        if (ae != null) {
            return (FlowActor)ae.getActor();
        }
        return null;
    }

    public NodeForPortfolio getNode() {
        return this.portfolioNode;
    }
}

