/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.ActorConfigBoolean;
import edu.uchc.connjur.wb.ActorConfigNumeric;
import edu.uchc.connjur.wb.Config;
import edu.uchc.connjur.wb.ResultStatus;
import edu.uchc.connjur.wb.gui.ConfigEditPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import org.apache.commons.lang.StringUtils;

public class ConfigEdit
extends ConfigEditPanel {
    private JLabel infoLabel;
    private JComboBox editCombo;
    private JCheckBox editCheckbox;
    private JButton doNowButton;
    protected boolean isBoolean;

    public ConfigEdit(Config c, ConfigEditPanel.ConfigEditClient client) {
        super(c, client);
        assert (c == this.actorConfig);
        super.add(this.unitsLabel);
        this.infoLabel = new JLabel();
        this.add(this.infoLabel);
        this.isBoolean = this.actorConfig instanceof ActorConfigBoolean;
        super.setActorLabel();
        if (this.isBoolean) {
            this.setBoolean();
            return;
        }
        switch (this.actorConfig.getValidationType()) {
            case DYNAMIC_LIST: 
            case STATIC_LIST: {
                this.setList(this.actorConfig.getList());
                break;
            }
            case STATIC_RANGE: 
            case DYNAMIC_RANGE: {
                this.setRange();
            }
            case METHOD: 
            case NONE: {
                this.updateText();
                this.editText.setInputVerifier(this.getVerifier());
            }
        }
        String units = this.actorConfig.getUnits();
        if (units != null) {
            this.unitsLabel.setText(units);
        }
    }

    protected void setInfoText(String infoText) {
        this.infoLabel.setText(infoText);
    }

    protected void setEditList(Object[] list) {
        this.editCombo = new JComboBox();
        this.editCombo.setModel(new DefaultComboBoxModel<Object>(list));
        this.editCombo.setBorder(new LineBorder(Color.BLACK, 1, false));
        this.editPanel.add((Component)this.editCombo, "c");
        this.editPanelLayout.show(this.editPanel, "c");
    }

    protected void setEditCheckbox() {
        this.editCheckbox = new JCheckBox();
        this.editPanel.add((Component)this.editCheckbox, "k");
        this.editPanelLayout.show(this.editPanel, "k");
    }

    protected void setDoNowPushbutton() {
        String label = ConfigEdit.splitCamelCase(this.actorConfig.getName());
        label = StringUtils.capitalize((String)label);
        this.setIdText("");
        this.doNowButton = new JButton(label);
        this.editPanel.add((Component)this.doNowButton, "b");
        this.editPanelLayout.show(this.editPanel, "b");
    }

    protected void setList(Object[] list) {
        assert (this.actorConfig != null);
        assert (this.actorConfig.getValidationType() == Config.ValidationType.DYNAMIC_LIST || this.actorConfig.getValidationType() == Config.ValidationType.STATIC_LIST);
        this.setEditList(list);
        Object value = this.actorConfig.getDisplayValue();
        this.editCombo.setSelectedItem(value);
        this.editCombo.addActionListener(new ComboListener());
    }

    protected void setBoolean() {
        assert (this.actorConfig != null);
        assert (this.actorConfig instanceof ActorConfigBoolean);
        ActorConfigBoolean acb = (ActorConfigBoolean)this.actorConfig;
        if (!acb.flags().isSet(64L)) {
            this.setEditCheckbox();
            this.editCheckbox.setSelected((Boolean)acb.getValue());
            this.editCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActorConfigBoolean acb = (ActorConfigBoolean)ConfigEdit.this.actorConfig;
                    acb.setValue(Boolean.valueOf(ConfigEdit.this.editCheckbox.isSelected()));
                }
            });
        } else {
            assert (!((Boolean)acb.getValue()).booleanValue());
            this.setDoNowPushbutton();
            this.doNowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActorConfigBoolean acb = (ActorConfigBoolean)ConfigEdit.this.actorConfig;
                    acb.setValue(Boolean.valueOf(true));
                }
            });
        }
    }

    void setRange() {
        assert (this.actorConfig instanceof ActorConfigNumeric);
        ActorConfigNumeric configNumeric = (ActorConfigNumeric)this.actorConfig;
        Actor.MinMax range = configNumeric.getRange();
        StringBuilder sb = new StringBuilder();
        if (range.min == null) {
            sb.append("<=");
            sb.append(range.max);
        } else if (range.max == null) {
            sb.append(">=");
            sb.append(range.min);
        } else {
            sb.append('(');
            sb.append(range.min);
            sb.append(',');
            sb.append(range.max);
            sb.append(')');
        }
        this.infoLabel.setText(sb.toString());
    }

    @Override
    public Component getInfo() {
        return this.infoLabel;
    }

    @Override
    protected void escapePressed() {
        this.updateText();
        this.client.setResult(ResultStatus.GOOD);
    }

    @Override
    public void refresh() {
        if (!this.isBoolean) {
            switch (this.actorConfig.getValidationType()) {
                case DYNAMIC_LIST: {
                    this.setList(this.actorConfig.getList());
                }
                case STATIC_LIST: {
                    this.editCombo.setSelectedItem(this.actorConfig.getDisplayValue());
                    break;
                }
                case DYNAMIC_RANGE: {
                    this.setRange();
                }
                default: {
                    this.updateText();
                    break;
                }
            }
        } else if (!this.actorConfig.flags().isSet(64L)) {
            Boolean bValue = (Boolean)this.actorConfig.getValue();
            this.editCheckbox.setSelected(bValue);
        }
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (e.getSource() == ConfigEdit.this.editCombo);
            ConfigEdit.this.actorConfig.setDisplayValue(ConfigEdit.this.editCombo.getSelectedItem());
        }
    }
}

