/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.ActorConfigFloat;
import edu.uchc.connjur.wb.ActorConfigInt;
import edu.uchc.connjur.wb.ActorConfigString;
import edu.uchc.connjur.wb.Config;
import edu.uchc.connjur.wb.ResultStatus;
import edu.uchc.connjur.wb.gui.ActorConfigurationEntry;
import edu.uchc.connjur.wb.gui.ColorCatalog;
import edu.uchc.connjur.wb.gui.ConfigEdit;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;

public abstract class ConfigEditPanel
extends JPanel
implements ActorConfigurationEntry {
    public String ENTER_PRESSED = "Enter";
    public String ESCAPE_PRESSED = "Escape";
    protected JLabel idLabel;
    protected JPanel editPanel;
    protected JTextField editText;
    protected JLabel unitsLabel;
    protected CardLayout editPanelLayout = new CardLayout();
    protected Config actorConfig;
    protected ConfigEditClient client;
    protected static GraphicLogger lg = GraphicLogger.getLogger(ConfigEdit.class);
    protected static final String TEXT = "t";
    protected static final String COMBO = "c";
    protected static final String CHECKBOX = "k";
    protected static final String LABEL = "l";
    protected static final String BUTTON = "b";

    protected ConfigEditPanel(Config config, ConfigEditClient client) {
        this.client = client;
        this.actorConfig = config;
        boolean isPassword = this.actorConfig != null && this.actorConfig.flags().isSet(32L);
        this.setBackground(ColorCatalog.get().get(ColorCatalog.Item.EDITOR_BACKGROUND));
        BoxLayout thisLayout = new BoxLayout(this, 0);
        this.setLayout(thisLayout);
        this.idLabel = new JLabel();
        this.add(this.idLabel);
        this.editPanel = new JPanel();
        this.editPanel.setLayout(this.editPanelLayout);
        this.add(this.editPanel);
        this.editText = !isPassword ? new JTextField() : new JPasswordField();
        this.editPanel.add((Component)this.editText, TEXT);
        this.editText.setBorder(new LineBorder(Color.BLACK, 1, false));
        this.unitsLabel = new JLabel();
        InputMap imap = this.editText.getInputMap(0);
        ActionMap amap = this.editText.getActionMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        imap.put(enter, this.ENTER_PRESSED);
        amap.put(this.ENTER_PRESSED, new TextCarriageReturn());
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        imap.put(escape, this.ESCAPE_PRESSED);
        amap.put(this.ESCAPE_PRESSED, new EscapePress());
    }

    protected void setIdText(String idText) {
        this.idLabel.setText(ConfigEditPanel.splitCamelCase(idText));
    }

    protected void setEditText(String initial) {
        this.editPanelLayout.show(this.editPanel, TEXT);
        this.editText.setText(initial);
    }

    protected void updateText() {
        Object value = this.actorConfig.getDisplayValue();
        String display = value != null ? value.toString() : "";
        this.setEditText(display);
        this.setIdLabelColor();
    }

    protected abstract void escapePressed();

    protected void setIdLabelColor() {
        Color c = ColorCatalog.get().configLabel(this.actorConfig);
        this.idLabel.setForeground(c);
    }

    protected void setActorLabel() {
        StringBuilder sb = new StringBuilder(this.actorConfig.getName());
        int dim = this.actorConfig.getDimension();
        if (dim != 0) {
            sb.append('[');
            sb.append(dim);
            sb.append(']');
        }
        this.setIdText(sb.toString());
        this.setIdLabelColor();
    }

    protected InputVerifier getVerifier() {
        assert (this.actorConfig != null);
        if (this.actorConfig instanceof ActorConfigString) {
            return new StringVerifier();
        }
        if (this.actorConfig instanceof ActorConfigInt) {
            return new IntegerVerifier();
        }
        if (this.actorConfig instanceof ActorConfigFloat) {
            return new FloatVerifier();
        }
        return null;
    }

    @Override
    public Component getSelf() {
        return this;
    }

    @Override
    public Component getEdit() {
        return this.editPanel;
    }

    @Override
    public Component getTitle() {
        return this.idLabel;
    }

    @Override
    public Component getUnits() {
        return this.unitsLabel;
    }

    public static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    protected class EscapePress
    extends AbstractAction {
        protected EscapePress() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ConfigEditPanel.this.escapePressed();
        }
    }

    protected class TextCarriageReturn
    extends AbstractAction {
        protected TextCarriageReturn() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            InputVerifier iv = ConfigEditPanel.this.editText.getInputVerifier();
            assert (iv != null) : "input verifier not set on " + ConfigEditPanel.this.actorConfig.getName();
            iv.verify(ConfigEditPanel.this.editText);
        }
    }

    class StringVerifier
    extends TextVerifier {
        StringVerifier() {
        }

        @Override
        ResultStatus trySet(String in) {
            String value = ConfigEditPanel.this.actorConfig.getTranslator().userToInternal((Object)in).toString();
            assert (ConfigEditPanel.this.actorConfig instanceof ActorConfigString);
            ActorConfigString cs = (ActorConfigString)ConfigEditPanel.this.actorConfig;
            return cs.setValue(value);
        }
    }

    class IntegerVerifier
    extends TextVerifier {
        IntegerVerifier() {
        }

        @Override
        ResultStatus trySet(String in) {
            Integer number;
            String value = ConfigEditPanel.this.actorConfig.getTranslator().userToInternal((Object)in).toString();
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return new ResultStatus(value + " is not valid integer value");
            }
            assert (ConfigEditPanel.this.actorConfig instanceof ActorConfigInt);
            ActorConfigInt ci = (ActorConfigInt)ConfigEditPanel.this.actorConfig;
            return ci.setValue(number);
        }
    }

    class FloatVerifier
    extends TextVerifier {
        FloatVerifier() {
        }

        @Override
        ResultStatus trySet(String in) {
            Float f;
            String value = ConfigEditPanel.this.actorConfig.getTranslator().userToInternal((Object)in).toString();
            try {
                f = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException nfe) {
                return new ResultStatus(value + " is not valid float value");
            }
            assert (ConfigEditPanel.this.actorConfig instanceof ActorConfigFloat);
            ActorConfigFloat cf = (ActorConfigFloat)ConfigEditPanel.this.actorConfig;
            return cf.setValue(f);
        }
    }

    private abstract class TextVerifier
    extends InputVerifier {
        private TextVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            assert (ConfigEditPanel.this.actorConfig != null);
            assert (input == ConfigEditPanel.this.editText);
            String entered = ConfigEditPanel.this.editText.getText();
            ResultStatus rs = this.trySet(entered);
            boolean result = rs.isGood();
            ConfigEditPanel.this.client.setResult(rs);
            return result;
        }

        abstract ResultStatus trySet(String var1);

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            boolean result = super.shouldYieldFocus(input);
            if (lg.isInfoEnabled()) {
                lg.graphics("should yield is " + result);
            }
            return result;
        }
    }

    public static interface ConfigEditClient {
        public void setResult(ResultStatus var1);
    }
}

