/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.ActorConfigString;
import edu.uchc.connjur.wb.Config;
import edu.uchc.connjur.wb.ResultStatus;
import edu.uchc.connjur.wb.UserPreference;
import edu.uchc.connjur.wb.annotation.ConfigEditor;
import edu.uchc.connjur.wb.annotation.EditorType;
import edu.uchc.connjur.wb.gui.ActorConfigurationEditor;
import edu.uchc.connjur.wb.gui.ActorConfigurationEntry;
import edu.uchc.connjur.wb.gui.ConfigEditPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ConfigFilename
extends ConfigEditPanel
implements ActorConfigurationEntry {
    public static final String LAST_DIRECTORY_PREF = "lastDirectory";
    public static final String LAST_FILE_PREF = "lastFileDirectory";
    private JPanel buttonPanel;
    private JButton filechooseBtn;
    private boolean needDirectory;
    private ActorConfigString acs;

    public ConfigFilename(Config c, ConfigEditPanel.ConfigEditClient client, boolean needDirectory) {
        super(c, client);
        assert (this.actorConfig == c);
        this.buttonPanel = new JPanel();
        this.add(this.buttonPanel);
        this.filechooseBtn = new JButton();
        this.buttonPanel.add(this.filechooseBtn);
        this.filechooseBtn.setText("...");
        this.filechooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFilename.this.openFileChooser();
            }
        });
        super.add(this.unitsLabel);
        super.setActorLabel();
        this.acs = (ActorConfigString)c;
        this.needDirectory = needDirectory;
        this.setEditText((String)this.acs.getValue());
        this.editText.setInputVerifier(new ConfigEditPanel.StringVerifier());
    }

    public static void init() {
    }

    @Override
    public Component getInfo() {
        return this.buttonPanel;
    }

    private void openFileChooser() {
        try {
            JFileChooser fc = new JFileChooser();
            fc.setMultiSelectionEnabled(false);
            Preferences pref = UserPreference.userPrefFor(ConfigFilename.class);
            if (this.needDirectory) {
                String userDir = System.getProperty("user.dir");
                String def = pref.get(LAST_DIRECTORY_PREF, userDir);
                File defaultDir = new File(def);
                if (defaultDir.exists() && defaultDir.isDirectory()) {
                    fc.setCurrentDirectory(defaultDir);
                }
                fc.setFileSelectionMode(1);
            } else {
                String def = pref.get(LAST_FILE_PREF, System.getProperty("user.dir"));
                File defaultDir = new File(def);
                if (defaultDir.exists() && defaultDir.isDirectory()) {
                    fc.setCurrentDirectory(defaultDir);
                }
                fc.setFileSelectionMode(0);
            }
            int rval = fc.showOpenDialog(this);
            if (rval == 0) {
                File parentDirectory;
                File selectedFile = fc.getSelectedFile();
                String filename = selectedFile.getAbsolutePath();
                ActorConfigString acs = (ActorConfigString)this.actorConfig;
                ResultStatus rs = acs.setValue(filename);
                this.client.setResult(rs);
                if (rs.isGood()) {
                    super.setEditText(filename);
                }
                if ((parentDirectory = selectedFile.getAbsoluteFile().getParentFile()) != null) {
                    String parentPath = parentDirectory.getAbsolutePath();
                    if (this.needDirectory) {
                        pref.put(LAST_DIRECTORY_PREF, parentPath);
                    } else {
                        pref.put(LAST_FILE_PREF, parentPath);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void escapePressed() {
        ActorConfigString acs = (ActorConfigString)this.actorConfig;
        this.editText.setText((String)acs.getValue());
    }

    @Override
    public void refresh() {
        Object o = this.actorConfig.getValue();
        if (o != null) {
            this.setEditText(o.toString());
        } else {
            this.setEditText("");
        }
    }

    static {
        ActorConfigurationEditor.register(new ProviderImpl());
    }

    public static class ProviderImpl
    implements ActorConfigurationEditor.Provider {
        @Override
        public ActorConfigurationEntry supports(ConfigEditor annotation, Config config, ConfigEditPanel.ConfigEditClient client) {
            EditorType etype = annotation.value();
            switch (etype) {
                case FILE: {
                    assert (config instanceof ActorConfigString);
                    return new ConfigFilename(config, client, false);
                }
                case DIRECTORY: {
                    assert (config instanceof ActorConfigString);
                    return new ConfigFilename(config, client, true);
                }
            }
            return null;
        }
    }
}

