/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.ActorElement;
import edu.uchc.connjur.wb.Portfolio;
import edu.uchc.connjur.wb.WorkflowElement;
import edu.uchc.connjur.wb.WorkflowNode;
import edu.uchc.connjur.wb.gui.ActorVisual;
import edu.uchc.connjur.wb.gui.ColorCatalog;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.PortfolioVisual;
import edu.uchc.connjur.wb.gui.WorkflowCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;

public abstract class ElementVisual {
    private static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    protected int x;
    protected int y;
    protected boolean userPositioned;
    protected int flowInX;
    protected int flowOutX;
    protected WorkflowNode node;
    protected BufferedImage ourImage;
    protected WorkflowCanvas owner;
    protected List<ElementVisual> children = new ArrayList<ElementVisual>();
    protected boolean selected;
    protected TextJustification justification = TextJustification.CENTER;
    public static int STANDARD_HEIGHT = 100;
    public static int STANDARD_WIDTH = 100;
    public static int MARGIN = 3;
    protected static GraphicLogger lg = GraphicLogger.getLogger(ElementVisual.class);
    protected static ColorCatalog colorCatalog = ColorCatalog.get();
    private static Font[] fontArray = new Font[]{DEFAULT_FONT, DEFAULT_FONT};
    protected static Stroke selectedStroke = new BasicStroke(5.0f);
    protected static Stroke nonselectedStroke = new BasicStroke(1.0f);
    private int childrenHeight = 0;

    public static Font getFont() {
        return fontArray[0];
    }

    public static void setFont(Font font) {
        ElementVisual.fontArray[0] = font;
    }

    public ElementVisual(WorkflowNode element, WorkflowCanvas owner) {
        this.node = element;
        this.owner = owner;
    }

    public ElementVisual() {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public WorkflowNode getNode() {
        return this.node;
    }

    public void setNode(WorkflowNode node) {
        this.node = node;
    }

    public boolean nodeTypeSameAs(ElementVisual other) {
        return this.node.getClass() == other.node.getClass();
    }

    public boolean isUserPositioned() {
        return this.userPositioned;
    }

    public void setUserPositioned(boolean userPositioned) {
        this.userPositioned = userPositioned;
    }

    public Point getFlowIn() {
        return new Point(this.x + this.flowInX, this.y);
    }

    public Point getFlowOut() {
        return new Point(this.x + this.flowOutX, this.y);
    }

    public Collection<ElementVisual> getChildren() {
        return this.children;
    }

    public void rebuildChildrenCollection() {
        this.children.clear();
        for (WorkflowNode node : this.node.getSuccessors()) {
            if (node.getWorkflowElement().isDeletePending()) continue;
            ElementVisual child = this.owner.getVisual(node);
            this.children.add(child);
            child.rebuildChildrenCollection();
        }
    }

    public void addChild(ElementVisual child) {
        this.children.add(child);
    }

    public int calculateChildrenHeight(int separation) {
        if (this.children.size() == 0) {
            this.childrenHeight = this.getHeight();
        } else {
            int total = 0;
            for (ElementVisual c : this.children) {
                total += c.calculateChildrenHeight(separation);
            }
            this.childrenHeight = Math.max(total += separation * (this.children.size() - 1), this.getHeight());
        }
        return this.childrenHeight;
    }

    public int getChildrenHeight() {
        return this.childrenHeight;
    }

    protected Stroke selectionStroke(boolean isSelected) {
        return isSelected ? selectedStroke : nonselectedStroke;
    }

    abstract int getWidth();

    abstract int getHeight();

    public abstract boolean inside(int var1, int var2);

    protected abstract int maxTextWidthForHeight(int var1);

    protected abstract Point topLeftOfText(Rectangle2D var1);

    protected abstract BufferedImage buildImage(Graphics2D var1);

    protected abstract String getDescription();

    public abstract void notifyClient(WorkflowCanvas.CanvasClient var1, boolean var2, boolean var3);

    protected void writeDescriptionLabel(Graphics2D g) throws AssertionError {
        String[] parts;
        boolean works = this.writeDescriptionLabel(g, this.getDescription());
        if (works) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String p : parts = this.getDescription().split("\\s")) {
            sb.append(p.charAt(0));
        }
        String abbr = sb.toString();
        this.writeDescriptionLabel(g, abbr);
    }

    protected boolean writeDescriptionLabel(Graphics2D g, String desc) throws AssertionError {
        double scale = this.owner.getScale();
        Rectangle2D boundingRect = null;
        Rectangle2D scaled = null;
        int width = (int)(scale * (double)this.getWidth());
        boolean goodFountFound = false;
        Font fontToUse = null;
        AttributedString aString = null;
        int fontIndex = 0;
        while (!goodFountFound) {
            if (fontIndex == fontArray.length) {
                return false;
            }
            fontToUse = fontArray[fontIndex];
            String fontName = fontToUse.getFontName();
            int fontStyle = fontToUse.getStyle();
            aString = new AttributedString(desc);
            for (int fontSize = (int)(scale * (double)fontToUse.getSize()); fontSize > 2; --fontSize) {
                if (fontSize != fontToUse.getSize()) {
                    fontToUse = new Font(fontName, fontStyle, fontSize);
                }
                if ((boundingRect = ElementVisual.textSize(g, width, fontToUse, aString)) == null) continue;
                scaled = this.owner.inverseScaled(boundingRect);
                int scaledHeight = (int)scaled.getHeight();
                int maxWidth = (int)(scale * (double)this.maxTextWidthForHeight(scaledHeight));
                if (!(boundingRect.getWidth() <= (double)maxWidth)) continue;
                goodFountFound = true;
                width = maxWidth;
                break;
            }
            ++fontIndex;
        }
        this.writeTheText(g, aString, scaled, boundingRect);
        return true;
    }

    private void writeTheText(Graphics2D g, AttributedString aString, Rectangle2D scaled, Rectangle2D boundingRect) {
        Point startingPoint = this.owner.scale(this.topLeftOfText(scaled));
        int ypos = startingPoint.y;
        aString.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
        LineBreakMeasurer lbm = new LineBreakMeasurer(aString.getIterator(), g.getFontRenderContext());
        boolean first = true;
        TextLayout textLayout;
        while ((textLayout = lbm.nextLayout((float)boundingRect.getWidth() + 1.0f, Integer.MAX_VALUE, true)) != null) {
            int xoffset;
            if (first) {
                ypos = (int)((float)ypos + textLayout.getAscent());
                first = false;
            }
            switch (this.justification) {
                case LEFT: {
                    xoffset = 0;
                    break;
                }
                case RIGHT: {
                    xoffset = (int)(boundingRect.getWidth() - textLayout.getBounds().getWidth());
                    break;
                }
                case CENTER: {
                    xoffset = (int)((boundingRect.getWidth() - textLayout.getBounds().getWidth()) / 2.0);
                    break;
                }
                default: {
                    assert (false) : "unimplemented TextJustification";
                    xoffset = 0;
                }
            }
            textLayout.draw(g, startingPoint.x + xoffset, ypos);
            if (lg.isGraphicsEnabled()) {
                lg.graphics("drawing text width " + textLayout.getBounds().getWidth() + " at " + ypos);
            }
            ypos = (int)((double)ypos + textLayout.getBounds().getHeight());
        }
        return;
    }

    static Rectangle2D textSize(Graphics2D g, int width, Font f, AttributedString aString) {
        double w = 0.0;
        double h = 0.0;
        aString.addAttribute(TextAttribute.FONT, f);
        int targetLength = aString.getIterator().getEndIndex();
        LineBreakMeasurer measurer = new LineBreakMeasurer(aString.getIterator(), g.getFontRenderContext());
        boolean layingOut = true;
        while (layingOut) {
            TextLayout textLayout = measurer.nextLayout(width, Integer.MAX_VALUE, true);
            if (textLayout == null) {
                layingOut = false;
                continue;
            }
            Rectangle2D r = textLayout.getBounds();
            w = Math.max(w, r.getWidth());
            h += r.getHeight();
        }
        if (measurer.getPosition() < targetLength) {
            return null;
        }
        return new Rectangle2D.Double(0.0, 0.0, w, h);
    }

    public void paint(Graphics2D g) {
        if (this.ourImage == null) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("building image for " + this);
                lg.graphics("bounds are " + g.getDeviceConfiguration().getBounds());
            }
            this.ourImage = this.buildImage(g);
        }
        int x = (int)((double)this.leftX() * this.owner.getScale());
        int y = (int)((double)this.topY() * this.owner.getScale());
        if (lg.isGraphicsEnabled()) {
            lg.graphics("painting " + this + " at " + x + "," + y);
        }
        g.drawImage((Image)this.ourImage, x, y, null);
    }

    public final int leftX() {
        return this.getX() - this.getWidth() / 2;
    }

    public final int topY() {
        return this.getY() - this.getHeight() / 2;
    }

    public void invalidateImage() {
        this.ourImage = null;
        this.owner.repaint();
    }

    public void invalidateChildren() {
        this.ourImage = null;
        for (ElementVisual child : this.children) {
            child.invalidateChildren();
        }
    }

    public static ElementVisual visualFor(WorkflowNode node, WorkflowCanvas owner) {
        assert (node != null);
        WorkflowElement we = node.getWorkflowElement();
        if (we instanceof ActorElement) {
            return new ActorVisual(node, owner);
        }
        if (we instanceof Portfolio) {
            return new PortfolioVisual(node, owner);
        }
        assert (false);
        return null;
    }

    public void setSelected(boolean isSelected) {
        if (isSelected == this.selected) {
            return;
        }
        this.selected = isSelected;
        this.invalidateImage();
    }

    public WorkflowElement getWorkflowElement() {
        return this.node.getWorkflowElement();
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseLeft() {
    }

    public abstract void doubleClicked(JFrame var1, int var2, int var3);

    public static enum TextJustification {
        CENTER,
        RIGHT,
        LEFT;

    }
}

