/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -733053413653940410L;
    private JPanel selectionPanel;
    private JList fontList;
    private JList sizeList;
    private JCheckBox boldCheckBox;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    private JButton cancelButton;
    private JButton buttonOk;
    private JPanel jPanel1;
    private JTextArea sampleText;
    private JCheckBox italicsCheckBox;
    private JPanel buttonPanel;
    private Font theFont;

    public static Font chooseFont(Frame owner, Font currentFont) {
        FontChooser fc = new FontChooser(owner);
        fc.setCurrent(currentFont);
        fc.setVisible(true);
        return fc.getFont();
    }

    public FontChooser(Frame owner) {
        super(owner, "Font chooser", true);
        this.initGUI();
        this.fillContent();
        this.pack();
    }

    @Override
    public Font getFont() {
        return this.theFont;
    }

    private void initGUI() {
        BorderLayout thisLayout = new BorderLayout();
        this.getContentPane().setLayout(thisLayout);
        this.selectionPanel = new JPanel();
        this.getContentPane().add((Component)this.selectionPanel, "North");
        this.jScrollPane1 = new JScrollPane();
        this.selectionPanel.add(this.jScrollPane1);
        this.fontList = new JList();
        this.jScrollPane1.setViewportView(this.fontList);
        this.fontList.setPreferredSize(new Dimension(300, 0));
        this.fontList.addListSelectionListener(this);
        this.jScrollPane2 = new JScrollPane();
        this.selectionPanel.add(this.jScrollPane2);
        this.sizeList = new JList();
        this.jScrollPane2.setViewportView(this.sizeList);
        this.sizeList.setPreferredSize(new Dimension(100, 0));
        this.sizeList.addListSelectionListener(this);
        this.buttonPanel = new JPanel();
        BoxLayout buttonPanelLayout = new BoxLayout(this.buttonPanel, 1);
        this.selectionPanel.add(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        this.italicsCheckBox = new JCheckBox();
        this.buttonPanel.add(this.italicsCheckBox);
        this.italicsCheckBox.setText("Italics");
        this.italicsCheckBox.addActionListener(this);
        this.boldCheckBox = new JCheckBox();
        this.buttonPanel.add(this.boldCheckBox);
        this.boldCheckBox.setText("Bold");
        this.boldCheckBox.addActionListener(this);
        this.sampleText = new JTextArea();
        this.getContentPane().add((Component)this.sampleText, "Center");
        this.jPanel1 = new JPanel();
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.buttonOk = new JButton();
        this.jPanel1.add(this.buttonOk);
        this.buttonOk.setText("OK");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton();
        this.jPanel1.add(this.cancelButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.theFont = null;
                FontChooser.this.setVisible(false);
            }
        });
    }

    private void fillContent() {
        this.fontList.setSelectionMode(0);
        this.sizeList.setSelectionMode(0);
        Vector<String> fontNames = new Vector<String>();
        for (Font f : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            fontNames.add(f.getFontName());
        }
        this.fontList.setListData(fontNames);
        this.setSizing(this.fontList, fontNames);
        Vector<Integer> sizes = new Vector<Integer>();
        for (int s = 6; s < 72; s += 2) {
            sizes.add(s);
        }
        this.sizeList.setListData(sizes);
        this.setSizing(this.sizeList, sizes);
        this.sampleText.setText("The CONNJUR Project is developing an open source integration environment for \nbiomolecular NMR data analysis. CONNJUR software is a workflow generator, \nbased on legacy NMR analysis applications, that is being developed as Open \nSource Software -- it is perpetually free for anyone to use, modify and distribute. ");
    }

    private void setSizing(JList list, Vector<?> content) {
        Rectangle bounds = list.getCellBounds(0, 0);
        int cellHt = (int)bounds.getHeight();
        int cellWidth = (int)list.getPreferredSize().getWidth();
        list.setFixedCellHeight(cellHt);
        list.setFixedCellWidth(cellWidth);
        Dimension d = new Dimension(cellWidth, cellHt * content.size());
        list.setPreferredSize(d);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateFont();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateFont();
    }

    private void updateFont() {
        String family = (String)this.fontList.getSelectedValue();
        Integer size = (Integer)this.sizeList.getSelectedValue();
        if (family == null || size == null) {
            return;
        }
        boolean italic = this.italicsCheckBox.isSelected();
        boolean bold = this.boldCheckBox.isSelected();
        int type = 0;
        if (italic) {
            type |= 2;
        }
        if (bold) {
            type |= 1;
        }
        this.theFont = new Font(family, type, size);
        this.sampleText.setFont(this.theFont);
        int HEIGHT_TOP_MARGIN = 10;
        Dimension textPreferred = this.sampleText.getPreferredSize();
        int existingWidth = this.getWidth();
        int newWidth = Math.max(existingWidth, (int)textPreferred.getWidth());
        double totalHeight = this.selectionPanel.getPreferredSize().getHeight() + this.sampleText.getPreferredSize().getHeight() + this.buttonPanel.getPreferredSize().getHeight();
        int newHeight = Math.max(this.getHeight(), (int)totalHeight + 10);
        Dimension ps = new Dimension(newWidth, newHeight);
        this.setSize(ps);
        this.invalidate();
    }

    private void setCurrent(Font currentFont) {
        String name = currentFont.getFontName();
        this.fontList.setSelectedValue(name, true);
        int size = currentFont.getSize();
        this.sizeList.setSelectedValue(size, true);
        int style = currentFont.getStyle();
        this.boldCheckBox.setSelected((style & 1) == 1);
        this.italicsCheckBox.setSelected((style & 2) == 2);
    }
}

