/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.spectrumtranslator.DimInfoLabel;
import edu.uchc.connjur.spectrumtranslator.FileFormatLabel;
import edu.uchc.connjur.spectrumtranslator.SelectionType;

public enum FormatLabel {
    VARIAN((DimInfoLabel)FileFormatLabel.VARIAN),
    BRUKER((DimInfoLabel)FileFormatLabel.BRUKER),
    NMRPIPE((DimInfoLabel)FileFormatLabel.NMRPIPE),
    TOOLKIT((DimInfoLabel)FileFormatLabel.TOOLKIT),
    CONNJUR(new ConnjurLabel());

    private DimInfoLabel dimInfoLabel;

    public DimInfoLabel getDimInfoLabel() {
        return this.dimInfoLabel;
    }

    private FormatLabel(DimInfoLabel dil) {
        this.dimInfoLabel = dil;
    }

    private static class ConnjurLabel
    implements DimInfoLabel {
        private ConnjurLabel() {
        }

        public String toCONNJURSTString() {
            return null;
        }

        public String getCarrierPPM(int index) {
            return "Carrrier PPM";
        }

        public String getFirstOrderPhase(int index) {
            return "First order phase correction";
        }

        public String getDataMode(int index) {
            return "Experimental Collection Mode";
        }

        public String getAnalysisDomain(int index) {
            return "AnalysisDomain";
        }

        public String getName(int index) {
            return "Nucleus Label";
        }

        public String getNegateImaginaries(int index) {
            return "Negate Imaginaries";
        }

        public String getSignAlternation(int index) {
            return "Alternate Signs";
        }

        public String getSpectralFrequency(int index) {
            return "Spectral Frequency";
        }

        public String getSweepWidth(int index) {
            return "Sweep Width";
        }

        public String getZeroOrderPhase(int index) {
            return "Zero order phase correction";
        }

        public String getAxisLabel(int index) {
            return Integer.toString(index + 1);
        }

        public SelectionType getSelectionType() {
            return null;
        }

        public String getDisplayName() {
            return "CONNJUR";
        }

        public String getFirstScalePoint(int index) {
            return "First Point On Spectrum (Hz)";
        }
    }
}

