/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.gui.GraphicLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.LevelRangeFilter;

public class LogWindow
extends JFrame {
    private JButton closeButton;
    private JTextArea logTextArea;
    private JButton clearButton;
    private JScrollPane jScrollPane1;
    private JPanel buttonPanel;
    private Level originalLevel;
    private Collection<Appender> previousAppenders = new ArrayList<Appender>();
    private LogAppender ourAppender;
    private LevelRangeFilter rangeFilter = new LevelRangeFilter();
    private Level[] supportedLevels = new Level[]{Level.ALL, Level.DEBUG, GraphicLogger.GRAPHICS, Level.INFO, Level.ERROR, Level.FATAL, Level.OFF};
    private boolean[] filterLevel = new boolean[this.supportedLevels.length];
    private static final GraphicLogger lg = GraphicLogger.getLogger(LogWindow.class);
    private static final long serialVersionUID = -8259773985350019430L;
    public static final String LAYOUT_PATTERN = "[%t] %-5p %c %x --> %m %n";
    public static Level DEFAULT_LOG_LEVEL = Level.INFO;
    private JPanel jPanel1;
    private JLabel jLabel_IL;
    private StringBuilder sink = new StringBuilder();
    private Timer timer;

    private static GraphicsConfiguration findLogDevice() throws HeadlessException {
        GraphicsDevice defaultScreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i] == defaultScreen || devices[i].getType() != 0) continue;
            return devices[i].getDefaultConfiguration();
        }
        return defaultScreen.getDefaultConfiguration();
    }

    public LogWindow() throws HeadlessException {
        super("Workflow Builder Java log", LogWindow.findLogDevice());
        this.initGUI();
        Logger rootLogger = GraphicLogger.getRootLogger();
        this.originalLevel = rootLogger.getLevel();
        this.rangeFilter.setAcceptOnMatch(true);
        this.rangeFilter.setLevelMax(Level.OFF);
        this.setLevel(DEFAULT_LOG_LEVEL);
        this.ourAppender = new LogAppender(this.logTextArea, this.rangeFilter);
        Rectangle bounds = super.getGraphicsConfiguration().getBounds();
        Dimension preferred = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight() - 100);
        super.setPreferredSize(preferred);
        super.setMaximizedBounds(bounds);
        super.setExtendedState(super.getExtendedState() | 6);
        this.timer = new Timer(5000, new Updater(this.logTextArea));
    }

    public void deactivate() {
        Logger rootLogger = GraphicLogger.getRootLogger();
        rootLogger.setLevel(this.originalLevel);
        this.setVisible(false);
        rootLogger.removeAppender((Appender)this.ourAppender);
        for (Appender a : this.previousAppenders) {
            rootLogger.addAppender(a);
        }
        this.timer.stop();
    }

    public void activate() {
        this.pack();
        this.timer.start();
        if (lg.isDebugEnabled()) {
            lg.debug("activated. Preferred size is " + this.getPreferredSize());
        }
        this.setVisible(true);
        this.setAppenders(Logger.getRootLogger());
    }

    private void setAppenders(Logger lg) {
        this.previousAppenders.clear();
        Enumeration e = lg.getAllAppenders();
        while (e.hasMoreElements()) {
            Appender a = (Appender)e.nextElement();
            if (a == this.ourAppender) continue;
            this.previousAppenders.add(a);
            lg.removeAppender(a);
        }
        lg.addAppender((Appender)this.ourAppender);
    }

    private void initGUI() {
        try {
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane1, "Center");
            this.jScrollPane1.setPreferredSize(new Dimension(500, 200));
            this.logTextArea = new JTextArea();
            this.jScrollPane1.setViewportView(this.logTextArea);
            this.logTextArea.setText("Java developer message log\n");
            this.buttonPanel = new JPanel();
            BoxLayout buttonPanelLayout = new BoxLayout(this.buttonPanel, 1);
            this.buttonPanel.setLayout(buttonPanelLayout);
            this.getContentPane().add((Component)this.buttonPanel, "West");
            this.jLabel_IL = new JLabel();
            this.buttonPanel.add(this.jLabel_IL);
            this.jLabel_IL.setText(" Logging Level ");
            this.jLabel_IL.setBorder(BorderFactory.createEtchedBorder(1));
            this.fillButtonPanel();
            this.jPanel1 = new JPanel();
            this.getContentPane().add((Component)this.jPanel1, "South");
            this.jPanel1.setPreferredSize(new Dimension(128, 25));
            this.closeButton = new JButton();
            this.jPanel1.add(this.closeButton);
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LogWindow.this.deactivate();
                }
            });
            this.clearButton = new JButton();
            this.jPanel1.add(this.clearButton);
            this.clearButton.setText("Clear Log");
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LogWindow.this.clearLog();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillButtonPanel() {
        assert (this.buttonPanel != null);
        ButtonGroup group = new ButtonGroup();
        for (Level lvl : this.supportedLevels) {
            JRadioButton button = new JRadioButton(lvl.toString());
            if (lvl.equals((Object)DEFAULT_LOG_LEVEL)) {
                button.setSelected(true);
            }
            this.buttonPanel.add(button);
            group.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogWindow.this.setLevel(e);
                }
            });
        }
        JLabel label = new JLabel("Filter out");
        this.buttonPanel.add(label);
        assert (this.supportedLevels.length == this.filterLevel.length);
        for (int i = 1; i < this.supportedLevels.length - 1; ++i) {
            Level lvl = this.supportedLevels[i];
            JRadioButton toggle = new JRadioButton(lvl.toString());
            this.buttonPanel.add(toggle);
            toggle.addItemListener(new ToggleHandler(i));
            if (lvl != GraphicLogger.GRAPHICS) continue;
            toggle.setSelected(true);
        }
    }

    private void setLevel(ActionEvent e) {
        String desc = e.getActionCommand();
        Level lvl = desc.equals(GraphicLogger.GRAPHICS.toString()) ? GraphicLogger.GRAPHICS : Level.toLevel((String)e.getActionCommand());
        this.setLevel(lvl);
    }

    private void setLevel(Level newLevel) {
        Logger rootLogger = GraphicLogger.getRootLogger();
        Level minimum = Level.toLevel((int)Math.min(newLevel.toInt(), this.originalLevel.toInt()));
        rootLogger.setLevel(minimum);
        this.rangeFilter.setLevelMin(newLevel);
    }

    private void clearLog() {
        this.logTextArea.setText(null);
    }

    private class ToggleHandler
    implements ItemListener {
        private int index;

        public ToggleHandler(int index) {
            this.index = index;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            boolean selected;
            assert (event.getSource() instanceof JRadioButton);
            JRadioButton tb = (JRadioButton)event.getSource();
            assert (tb.getText().equals(LogWindow.this.supportedLevels[this.index].toString()));
            ((LogWindow)LogWindow.this).filterLevel[this.index] = selected = tb.isSelected();
            if (lg.isGraphicsEnabled()) {
                lg.graphics("toggle " + tb.getText() + " set to " + selected);
            }
        }
    }

    private class Updater
    implements ActionListener {
        JTextArea logArea;

        public Updater(JTextArea logArea) {
            this.logArea = logArea;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String content;
            StringBuilder stringBuilder = LogWindow.this.sink;
            synchronized (stringBuilder) {
                content = LogWindow.this.sink.toString();
                LogWindow.this.sink.delete(0, LogWindow.this.sink.length());
            }
            this.logArea.append(content);
            this.logArea.setPreferredSize(null);
        }
    }

    private class LogAppender
    extends AppenderSkeleton {
        public LogAppender(JTextArea logArea, LevelRangeFilter rangeFilter) {
            this.addFilter((Filter)rangeFilter);
            this.setLayout((Layout)new PatternLayout(LogWindow.LAYOUT_PATTERN));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void append(LoggingEvent event) {
            Level lvl = event.getLevel();
            for (int i = 0; i < LogWindow.this.filterLevel.length; ++i) {
                if (!LogWindow.this.filterLevel[i] || LogWindow.this.supportedLevels[i] != lvl) continue;
                return;
            }
            Layout layout = this.getLayout();
            String formatted = layout.format(event);
            StringBuilder stringBuilder = LogWindow.this.sink;
            synchronized (stringBuilder) {
                LogWindow.this.sink.append(formatted);
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return true;
        }
    }
}

