/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.core.UserNotifier;
import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.ActorCatalogBuilder;
import edu.uchc.connjur.wb.ActorFactory;
import edu.uchc.connjur.wb.DataAccess;
import edu.uchc.connjur.wb.StrandCatalog;
import edu.uchc.connjur.wb.UniformDataElementFactory;
import edu.uchc.connjur.wb.context.InstallationContext;
import edu.uchc.connjur.wb.dataaccess.Factory;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.GuiDemoActor;
import edu.uchc.connjur.wb.gui.NullDatabase;
import edu.uchc.connjur.wb.gui.Splash;
import edu.uchc.connjur.wb.gui.WorkflowBuilder;
import edu.uchc.connjur.wb.gui.actor.DisplayNMRDraw;
import edu.uchc.connjur.wb.gui.component.ExceptionDialog;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.lf5.util.Resource;

public class Main
implements Thread.UncaughtExceptionHandler {
    public static GraphicLogger lg = null;
    public static final int REQUIRED_MAJOR = 1;
    public static final int REQUIRED_MINOR = 6;
    public static final String PROP_FILE = "log4j.properties";
    private static int majorFound;
    private static int minorFound;
    private static boolean nullDatabase;

    public static void main(String[] args) {
        File initFile = new File(PROP_FILE);
        Properties p = new Properties();
        if (initFile.exists()) {
            try {
                FileReader rdr = new FileReader(initFile);
                p.load(rdr);
                p.put("log4j.loggerFactory", "edu.uchc.connjur.wb.gui.GraphicLoggerFactory");
                PropertyConfigurator.configure((Properties)p);
            }
            catch (Exception e) {}
        } else {
            Resource cfg = new Resource(PROP_FILE);
            PropertyConfigurator.configure((URL)cfg.getURL());
        }
        lg = GraphicLogger.getLogger(Main.class);
        Splash splash = new Splash();
        if (!Main.checkVersion()) {
            splash.dispose();
            JOptionPane.showMessageDialog(null, "Workflow Builder requires Java version 1.6 or greater. Version found is " + majorFound + "." + minorFound, "Java version not supported", 0);
            System.exit(2);
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "WorkflowBuilder");
        if (SystemTray.isSupported()) {
            try {
                SystemTray tray = SystemTray.getSystemTray();
                Image img = Toolkit.getDefaultToolkit().getImage("ConnjurLogo4.icns");
                TrayIcon ti = new TrayIcon(img, "Graphical NMR Workflow Processing");
                tray.add(ti);
            }
            catch (AWTException e) {
                // empty catch block
            }
        }
        try {
            DataAccess da;
            if (lg.isInfoEnabled()) {
                lg.graphics("creating splash");
            }
            SwingUtilities.invokeAndWait(splash);
            while (!splash.isPainted()) {
                Thread.sleep(1L);
            }
            UserNotifier.getInstance().replaceProtocols((UserNotifier.NotificationProtocol)new NotifyDump());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setUncaughtExceptionHandler(new Main());
                }
            });
            ActorFactory af = ActorFactory.get();
            af.add((Actor)new DisplayNMRDraw(), InstallationContext.Tool.NMRPIPE, null, 100);
            if (System.getProperty("DEMOACTOR") != null) {
                af.add((Actor)new GuiDemoActor(), null, null, -1);
            }
            StrandCatalog.get();
            if (lg.isInfoEnabled()) {
                lg.graphics("initiatilizing database");
            }
            boolean bl = nullDatabase = (da = Factory.get()) == null;
            if (nullDatabase) {
                Factory.setDatabase((DataAccess)new NullDatabase());
            }
            if (lg.isInfoEnabled()) {
                lg.graphics("initiatilizing actor catalog");
            }
            ActorCatalogBuilder.init();
            if (lg.isInfoEnabled()) {
                lg.graphics("initiatilizing custom DataSet factory");
            }
            UniformDataElementFactory.init();
            if (lg.isInfoEnabled()) {
                lg.graphics("initiatilizing main screen");
            }
            String defaultLandF = UIManager.getSystemLookAndFeelClassName();
            Preferences node = Preferences.userNodeForPackage(WorkflowBuilder.class);
            String lookAndFeelClass = node.get("lookAndFeel", defaultLandF);
            UIManager.setLookAndFeel(lookAndFeelClass);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        WorkflowBuilder inst = new WorkflowBuilder();
                        inst.addWindowListener(new ExitApplicationOnWindowCloser());
                        if (nullDatabase) {
                            String title = inst.getTitle();
                            inst.setTitle("DEMO MODE -- " + title + " -- DEMO MODE");
                        }
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        inst.setMaximizedBounds(ge.getMaximumWindowBounds());
                        inst.setExtendedState(inst.getExtendedState() | 6);
                        inst.setVisible(true);
                    }
                    catch (Throwable e) {
                        Main.ProcessException(e);
                    }
                }
            });
            if (lg.isInfoEnabled()) {
                lg.graphics("closing splash");
            }
            splash.dispose();
        }
        catch (Throwable e) {
            splash.dispose();
            Main.ProcessException(e);
        }
    }

    private static void ProcessException(Throwable e) {
        new ExceptionDialog(e, true);
        System.exit(1);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Main.ProcessException(e);
    }

    public static boolean checkVersion() {
        String javaVersion = System.getProperty("java.version");
        String[] pieces = javaVersion.split("\\.");
        try {
            majorFound = Integer.parseInt(pieces[0]);
            minorFound = Integer.parseInt(pieces[1]);
            if (majorFound > 1) {
                return true;
            }
            if (majorFound < 1) {
                return false;
            }
            return minorFound >= 6;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static class NotifyDump
    implements UserNotifier.NotificationProtocol {
        private NotifyDump() {
        }

        public void tellUser(String message) {
        }
    }

    private static class ExitApplicationOnWindowCloser
    extends WindowAdapter {
        private ExitApplicationOnWindowCloser() {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            System.exit(0);
        }
    }
}

