/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.Portfolio;
import edu.uchc.connjur.wb.UniformDataElement;
import edu.uchc.connjur.wb.gui.component.UniformDataElementPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PortfolioViewer
extends JDialog {
    private UniformDataElementPanel dataPanel;
    private JSpinner dataElementSpinner;
    private JLabel activeLabel;
    private JPanel activePanel;
    private JSpinner activeDimensionSpinner;
    private JRadioButton persistentButton;
    private JPanel optionPanel;
    private JLabel daLabel;
    private JPanel jPanel1;
    private JButton closeButton;
    private JPanel buttonPanel;
    private Portfolio portfolio;

    private void initGUI() {
        try {
            this.dataPanel = new UniformDataElementPanel();
            this.getContentPane().add((Component)this.dataPanel, "Center");
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.buttonPanel.add((Component)this.jPanel1, "West");
            this.dataElementSpinner = new JSpinner();
            this.jPanel1.add((Component)this.dataElementSpinner, "Center");
            this.daLabel = new JLabel();
            this.jPanel1.add((Component)this.daLabel, "West");
            this.daLabel.setText("Data Element");
            this.closeButton = new JButton();
            this.buttonPanel.add((Component)this.closeButton, "East");
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PortfolioViewer.this.close();
                }
            });
            this.optionPanel = new JPanel();
            this.optionPanel.setLayout(new FlowLayout());
            this.getContentPane().add((Component)this.optionPanel, "North");
            this.persistentButton = new JRadioButton();
            this.optionPanel.add(this.persistentButton);
            this.persistentButton.setText("Store in database");
            this.activePanel = new JPanel();
            BorderLayout jPanel2Layout = new BorderLayout();
            this.activePanel.setLayout(jPanel2Layout);
            this.activeDimensionSpinner = new JSpinner();
            this.activePanel.add((Component)this.activeDimensionSpinner, "Center");
            this.activeLabel = new JLabel();
            this.activePanel.add((Component)this.activeLabel, "West");
            this.activeLabel.setText("Active Dimension:");
            this.optionPanel.add(this.activePanel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PortfolioViewer(Frame owner, Portfolio portfolio) {
        super(owner, "Portfolio", false);
        this.initGUI();
        this.portfolio = portfolio;
        boolean persistent = portfolio.isPersistent();
        this.persistentButton.setSelected(persistent);
        if (portfolio.getTypeValue() == Portfolio.Type.ANCHOR) {
            this.persistentButton.setEnabled(false);
        }
        int maxElements = portfolio.getNumberDataElements() - 1;
        this.dataElementSpinner.setModel(new SpinnerNumberModel(0, 0, maxElements, 1));
        int maxDim = portfolio.getNumberDimensions();
        int active = portfolio.getActiveDimension() + 1;
        this.activeDimensionSpinner.setModel(new SpinnerNumberModel(active, 1, maxDim, 1));
        this.activeDimensionSpinner.setEnabled(portfolio.canSetActiveDimension());
        this.activeDimensionSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                PortfolioViewer.this.setDimension();
            }
        });
        this.dataPanel.setDataElement((UniformDataElement)portfolio.getDataElement(0));
        Dimension sz = this.getPreferredSize();
        sz.height += 20;
        this.setSize(sz);
    }

    protected void setDimension() {
        assert (this.portfolio.canSetActiveDimension()) : "PortfolioViewer.setDimension";
        SpinnerNumberModel model = (SpinnerNumberModel)this.activeDimensionSpinner.getModel();
        int d = model.getNumber().intValue();
        this.portfolio.setActiveDimension(d - 1);
    }

    private void close() {
        boolean isAnchor;
        boolean bl = isAnchor = this.portfolio.getTypeValue() == Portfolio.Type.ANCHOR;
        if (!isAnchor) {
            if (this.persistentButton.isSelected()) {
                this.portfolio.setType(Portfolio.Type.PERSISTENT);
            } else {
                this.portfolio.setType(Portfolio.Type.MEMORY);
            }
        }
        this.setVisible(false);
        this.dispose();
    }
}

