/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.DataElement;
import edu.uchc.connjur.wb.NodeForPortfolio;
import edu.uchc.connjur.wb.Portfolio;
import edu.uchc.connjur.wb.SingleFid;
import edu.uchc.connjur.wb.WorkflowNode;
import edu.uchc.connjur.wb.event.PortfolioEvent;
import edu.uchc.connjur.wb.event.PortfolioListener;
import edu.uchc.connjur.wb.gui.ElementVisual;
import edu.uchc.connjur.wb.gui.PortfolioViewer;
import edu.uchc.connjur.wb.gui.WorkflowCanvas;
import edu.uchc.connjur.wb.gui.component.FidPanel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class PortfolioVisual
extends ElementVisual
implements PortfolioListener {
    protected Portfolio portfolio;
    protected Shape ourShape;
    protected Popup fidPopup;
    protected FidPanel fidPanel = new FidPanel();

    public PortfolioVisual(WorkflowNode node, WorkflowCanvas owner) {
        super(node, owner);
        this.portfolio = (Portfolio)node.getWorkflowElement();
        this.flowInX = -STANDARD_WIDTH / 2;
        this.flowOutX = STANDARD_WIDTH / 2;
        this.ourShape = new OurRectangle();
        this.portfolio.addListener((PortfolioListener)this);
    }

    @Override
    protected BufferedImage buildImage(Graphics2D g) {
        double scale = this.owner.getScale();
        int h = (int)((double)STANDARD_HEIGHT * scale);
        int w = (int)((double)STANDARD_WIDTH * scale);
        this.ourImage = g.getDeviceConfiguration().createCompatibleImage(w, h, 2);
        Shape sShape = this.owner.scaled(this.ourShape);
        Graphics2D imgG = this.ourImage.createGraphics();
        Color c = colorCatalog.portfolioImage(this.portfolio);
        imgG.setColor(c);
        imgG.fill(sShape);
        imgG.setColor(Color.BLACK);
        this.writeDescriptionLabel(imgG);
        imgG.setStroke(this.selectionStroke(this.selected));
        imgG.draw(sShape);
        return this.ourImage;
    }

    @Override
    protected String getDescription() {
        return this.portfolio.getDescription();
    }

    @Override
    int getHeight() {
        return STANDARD_HEIGHT;
    }

    @Override
    int getWidth() {
        return STANDARD_WIDTH;
    }

    @Override
    public boolean inside(int x, int y) {
        return this.ourShape.contains(x, y);
    }

    @Override
    protected int maxTextWidthForHeight(int height) {
        return STANDARD_WIDTH;
    }

    @Override
    protected Point topLeftOfText(Rectangle2D rectangle) {
        int x = (int)(((double)this.getWidth() - rectangle.getWidth()) / 2.0);
        int y = (int)(((double)this.getHeight() - rectangle.getHeight()) / 2.0);
        return new Point(x, y);
    }

    @Override
    public void notifyClient(WorkflowCanvas.CanvasClient client, boolean exclusive, boolean single) {
        NodeForPortfolio nfp = (NodeForPortfolio)this.node;
        client.portfolioSelected(nfp, exclusive, single);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        int elementIndex;
        if (lg.isGraphicsEnabled()) {
            lg.graphics("entered " + this);
        }
        if ((elementIndex = this.portfolio.getDataElementIndex()) < 0) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("no element, exiting");
            }
            return;
        }
        DataElement de = this.portfolio.getDataElement(elementIndex);
        SingleFid fid = de.getFirstFid();
        if (fid == null) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("no fid, exiting");
            }
            return;
        }
        this.fidPanel.setFid(fid, 1.0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle b = ge.getMaximumWindowBounds();
        int margin = (int)(b.getWidth() * 0.01);
        int x = event.getXOnScreen();
        int y = event.getYOnScreen();
        x = Math.min(x, (int)(b.getMaxX() - (double)this.fidPanel.getWidth() - (double)margin));
        this.fidPopup = PopupFactory.getSharedInstance().getPopup(this.owner, this.fidPanel, x, y);
        this.fidPopup.show();
    }

    @Override
    public void mouseLeft() {
        if (lg.isGraphicsEnabled()) {
            lg.graphics("exited " + this);
        }
        if (this.fidPopup != null) {
            this.fidPopup.hide();
        }
    }

    public void portfolioChanged(PortfolioEvent event) {
        switch (event.getReason()) {
            case DATA_ELEMENT_CHANGE: 
            case METADATA_ONLY: {
                super.invalidateImage();
                break;
            }
        }
    }

    @Override
    public void doubleClicked(JFrame windowOwner, int x, int y) {
        PortfolioViewer portfolioViewer = new PortfolioViewer((Frame)windowOwner, this.portfolio);
        portfolioViewer.setLocation(x, y);
        portfolioViewer.setVisible(true);
        this.owner.portfolioViewer = portfolioViewer;
    }

    private static class OurRectangle
    extends Rectangle {
        public OurRectangle() {
            super(ElementVisual.STANDARD_WIDTH - 1, ElementVisual.STANDARD_HEIGHT - 1);
        }
    }
}

