/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.DataAccess;
import edu.uchc.connjur.wb.Workflow;
import edu.uchc.connjur.wb.WorkflowBase;
import edu.uchc.connjur.wb.WorkflowBuilderProcessingException;
import edu.uchc.connjur.wb.WorkflowSearch;
import edu.uchc.connjur.wb.dataaccess.Factory;
import edu.uchc.connjur.wb.event.WeakListeners;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.component.ComboEditPanel;
import edu.uchc.connjur.wb.gui.component.TextEditPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class SearchWorkflow
extends JDialog {
    private JPanel topPanel;
    private JTable resultTable;
    private TextEditPanel keywordsPanel;
    private JButton deleteButton;
    private JPanel jPanel1;
    private JButton queryButton;
    private JPanel queryPanel;
    private TextEditPanel limitPanel;
    private JScrollPane jScrollPane1;
    private TextEditPanel notesPanel;
    private ComboEditPanel userPanel;
    private ComboEditPanel entityPanel;
    private JLabel statusLabel;
    private JButton cancelButton;
    private JButton openButton;
    private JPanel buttonPanel;
    private SearchTableModel tableModel;
    private Integer searchLimit = 3000;
    private StringBuilder statusInfo;
    private Vector<WorkflowSearch> workflows;
    private WorkflowBase selected = null;
    private static final String NO_FILTER = "All";
    private static GraphicLogger lg = GraphicLogger.getLogger(SearchWorkflow.class);

    public SearchWorkflow() {
        this.initGUI();
    }

    public SearchWorkflow(Frame owner) {
        super(owner, true);
        this.initGUI();
        this.setupSearch();
        this.setupTable();
        this.pack();
    }

    private void initGUI() {
        try {
            BoxLayout thisLayout = new BoxLayout(this.getContentPane(), 1);
            this.getContentPane().setLayout(thisLayout);
            this.jPanel1 = new JPanel();
            this.getContentPane().add(this.jPanel1);
            this.statusLabel = new JLabel();
            this.jPanel1.add(this.statusLabel);
            this.statusLabel.setText("search");
            this.topPanel = new JPanel();
            GridLayout topPanelLayout = new GridLayout(0, 2);
            topPanelLayout.setColumns(2);
            topPanelLayout.setHgap(5);
            topPanelLayout.setVgap(5);
            topPanelLayout.setRows(0);
            this.topPanel.setLayout(topPanelLayout);
            this.getContentPane().add(this.topPanel);
            this.entityPanel = new ComboEditPanel();
            BoxLayout entityPanelLayout = new BoxLayout(this.entityPanel, 1);
            this.entityPanel.setLayout(entityPanelLayout);
            this.topPanel.add(this.entityPanel);
            this.entityPanel.setLabelText("Entity");
            this.userPanel = new ComboEditPanel();
            BoxLayout userPanelLayout = new BoxLayout(this.userPanel, 1);
            this.userPanel.setLayout(userPanelLayout);
            this.topPanel.add(this.userPanel);
            this.userPanel.setLabelText("User");
            this.notesPanel = new TextEditPanel();
            BoxLayout notesPanelLayout = new BoxLayout(this.notesPanel, 1);
            this.notesPanel.setLayout(notesPanelLayout);
            this.topPanel.add(this.notesPanel);
            this.notesPanel.setLabelText("Notes");
            this.notesPanel.setFieldColumns(30);
            this.keywordsPanel = new TextEditPanel();
            BoxLayout keywordsPanelLayout = new BoxLayout(this.keywordsPanel, 1);
            this.keywordsPanel.setLayout(keywordsPanelLayout);
            this.topPanel.add(this.keywordsPanel);
            this.keywordsPanel.setLabelText("Keywords");
            this.keywordsPanel.setFieldColumns(30);
            this.limitPanel = new TextEditPanel();
            BoxLayout spacePanelLayout = new BoxLayout(this.limitPanel, 1);
            this.limitPanel.setLayout(spacePanelLayout);
            this.topPanel.add(this.limitPanel);
            this.limitPanel.setLabelText("Search Limit");
            this.queryPanel = new JPanel();
            this.topPanel.add(this.queryPanel);
            this.queryButton = new JButton();
            this.queryPanel.add(this.queryButton);
            this.queryButton.setText("Search");
            this.queryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SearchWorkflow.this.queryBottomActionPerformed(evt);
                }
            });
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add(this.jScrollPane1);
            this.jScrollPane1.setPreferredSize(new Dimension(0, 300));
            if (!Beans.isDesignTime()) {
                this.resultTable = new OurTable();
            } else {
                this.resultTable = new JTable();
                DefaultTableModel resultTableModel = new DefaultTableModel(new String[][]{{"One", "Two"}, {"Three", "Four"}}, new String[]{"Column 1", "Column 2"});
                this.resultTable.setModel(resultTableModel);
            }
            this.jScrollPane1.setViewportView(this.resultTable);
            this.buttonPanel = new JPanel();
            this.getContentPane().add(this.buttonPanel);
            this.openButton = new JButton();
            this.buttonPanel.add(this.openButton);
            this.openButton.setText("Open Workflow");
            this.openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SearchWorkflow.this.openButtonActionPerformed(evt);
                }
            });
            this.deleteButton = new JButton();
            this.buttonPanel.add(this.deleteButton);
            this.deleteButton.setText("Delete Workflow");
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SearchWorkflow.this.deleteWorkflow(evt);
                }
            });
            this.cancelButton = new JButton();
            this.buttonPanel.add(this.cancelButton);
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SearchWorkflow.this.cancelButtonActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workflow openWorkflow(int workflowId) {
        Workflow workflow;
        DataAccess da = Factory.get();
        try {
            Workflow workflow2;
            WeakListeners.enableNotifications((boolean)false);
            workflow = workflow2 = (Workflow)da.get(Workflow.class, Integer.valueOf(workflowId));
        }
        catch (Throwable throwable) {
            try {
                WeakListeners.enableNotifications((boolean)true);
                Workflow.notifyNewWorkflow();
                throw throwable;
            }
            catch (Exception e) {
                throw new WorkflowBuilderProcessingException("Unable to open workflow " + workflowId, (Throwable)e);
            }
        }
        WeakListeners.enableNotifications((boolean)true);
        Workflow.notifyNewWorkflow();
        return workflow;
    }

    public Workflow openWorkflow(Component client) {
        client.setCursor(Cursor.getPredefinedCursor(3));
        this.setVisible(true);
        if (this.selected != null) {
            return SearchWorkflow.openWorkflow(this.selected.getId());
        }
        return null;
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        int row = this.resultTable.getSelectedRow();
        if (row != -1) {
            this.selected = (WorkflowBase)this.workflows.get(row);
            this.setVisible(false);
            if (lg.isGraphicsEnabled()) {
                lg.graphics(this.selected.getId() + " selected");
            }
        } else {
            this.selected = null;
            this.statusLabel.setText("no row selected");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void queryBottomActionPerformed(ActionEvent evt) {
        this.doQuery();
    }

    private void deleteWorkflow(ActionEvent evt) {
        int row = this.resultTable.getSelectedRow();
        if (row != -1) {
            int index = this.resultTable.convertRowIndexToModel(row);
            this.selected = (WorkflowBase)this.workflows.get(index);
            int rc = JOptionPane.showConfirmDialog(this, "Do you wish to delete " + this.selected.describe() + "?", "Confirm Delete", 0);
            if (rc == 0) {
                this.selected.delete();
                this.workflows.remove(index);
                assert (this.resultTable.getModel() instanceof AbstractTableModel);
                AbstractTableModel atm = (AbstractTableModel)this.resultTable.getModel();
                atm.fireTableDataChanged();
            }
        } else assert (false) : "SearchWorkflow.deleteWorkflow";
    }

    private void setupSearch() {
        try {
            DataAccess da = Factory.get();
            Collection entities = da.namedSearch(String.class, WorkflowSearch.class, "entitySearch");
            Vector<String> entityVector = new Vector<String>();
            entityVector.add(NO_FILTER);
            entityVector.addAll(entities);
            this.entityPanel.setModel(new DefaultComboBoxModel(entityVector));
            Collection users = da.namedSearch(String.class, WorkflowSearch.class, "userSearch");
            Vector<String> userVector = new Vector<String>();
            userVector.add(NO_FILTER);
            userVector.addAll(users);
            this.userPanel.setModel(new DefaultComboBoxModel(userVector));
        }
        catch (Exception e) {
            throw new WorkflowBuilderProcessingException("searching workflows", (Throwable)e);
        }
    }

    private void setupTable() {
        this.workflows = new Vector();
        assert (this.workflows != null);
        OurTable ourTable = (OurTable)this.resultTable;
        ourTable.setAutoCreateRowSorter(true);
        this.tableModel = new SearchTableModel();
        this.resultTable.setModel(this.tableModel);
        this.openButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.resultTable.getSelectionModel().addListSelectionListener(new OkButtonManager());
        this.resultTable.getSelectionModel().setSelectionMode(0);
        this.doQuery();
    }

    private String getComboString(ComboEditPanel cep) {
        String value = cep.getText();
        if (value == NO_FILTER) {
            return null;
        }
        return value;
    }

    private String sqlSearchString(String value) {
        String trimmed = value.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        return "%" + trimmed + "%";
    }

    private void updateStatus(String label, String value) {
        if (value == null || value == NO_FILTER) {
            return;
        }
        String cleaned = value.replace("%", "");
        this.statusInfo.append(label);
        this.statusInfo.append(":  ");
        this.statusInfo.append(cleaned);
        this.statusInfo.append(", ");
    }

    private void doQuery() {
        try {
            String entity = this.getComboString(this.entityPanel);
            String user = this.getComboString(this.userPanel);
            String notes = this.sqlSearchString(this.notesPanel.getText());
            String keywords = this.sqlSearchString(this.keywordsPanel.getText());
            try {
                String limitString = this.limitPanel.getField().getText();
                int limit = Integer.parseInt(limitString);
                this.searchLimit = limit;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.limitPanel.getField().setText(Integer.toString(this.searchLimit));
            DataAccess da = Factory.get();
            this.workflows.clear();
            WorkflowSearch search = new WorkflowSearch();
            search.setEntity(entity);
            search.setUser(user);
            search.setKeywords(keywords);
            search.setNotes(notes);
            search.setLimit(this.searchLimit.intValue());
            Collection results = da.search(WorkflowSearch.class, (Object)search);
            this.workflows.addAll(results);
            assert (this.resultTable.getModel() instanceof AbstractTableModel);
            AbstractTableModel atm = (AbstractTableModel)this.resultTable.getModel();
            atm.fireTableDataChanged();
            this.statusInfo = new StringBuilder("Filters in place:  ");
            this.updateStatus("user", user);
            this.updateStatus("entity", entity);
            this.updateStatus("notes", notes);
            this.updateStatus("keywords", keywords);
            if (results.size() == this.searchLimit.intValue()) {
                this.statusInfo.append("Only ");
                this.statusInfo.append(this.searchLimit);
                this.statusInfo.append(" workflows returned");
            }
            this.statusLabel.setText(this.statusInfo.toString());
        }
        catch (Exception e) {
            throw new WorkflowBuilderProcessingException("searching workflows", (Throwable)e);
        }
    }

    private class OurTable
    extends JTable {
        private StringBuilder builder = new StringBuilder();

        private OurTable() {
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point p = event.getPoint();
            int rowIndex = this.rowAtPoint(p);
            if (rowIndex == -1) {
                return "";
            }
            WorkflowBase wb = (WorkflowBase)SearchWorkflow.this.workflows.get(rowIndex);
            this.builder.delete(0, this.builder.length());
            this.builder.append("<html>");
            this.builder.append("<b>Notes:</b> ");
            this.builder.append(wb.getNotes());
            this.builder.append("<br><b>Keywords: </b>");
            this.builder.append(wb.getKeywords());
            this.builder.append("</html>");
            return this.builder.toString();
        }
    }

    private class OkButtonManager
    implements ListSelectionListener {
        private OkButtonManager() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean rowSelected = SearchWorkflow.this.resultTable.getSelectedRow() != -1;
            SearchWorkflow.this.openButton.setEnabled(rowSelected);
            SearchWorkflow.this.deleteButton.setEnabled(rowSelected);
        }
    }

    private class SearchTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"ID", "Entity", "User", "Last Used", "Created"};

        private SearchTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return SearchWorkflow.this.workflows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WorkflowBase wb = (WorkflowBase)SearchWorkflow.this.workflows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return wb.getId();
                }
                case 1: {
                    return wb.getEntity();
                }
                case 2: {
                    return wb.getUser();
                }
                case 3: {
                    return wb.lastUsed();
                }
                case 4: {
                    return wb.created();
                }
            }
            assert (false);
            return null;
        }
    }
}

