/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.spectrumtranslator.CodeUtil;
import edu.uchc.connjur.wb.BunchOfThreads;
import edu.uchc.connjur.wb.DataElement;
import edu.uchc.connjur.wb.NodeForActor;
import edu.uchc.connjur.wb.NodeForLoader;
import edu.uchc.connjur.wb.NodeForPortfolio;
import edu.uchc.connjur.wb.ProcessingContextImpl;
import edu.uchc.connjur.wb.Strand;
import edu.uchc.connjur.wb.StrandCatalog;
import edu.uchc.connjur.wb.Workflow;
import edu.uchc.connjur.wb.WorkflowBase;
import edu.uchc.connjur.wb.WorkflowNode;
import edu.uchc.connjur.wb.actor.FlowActor;
import edu.uchc.connjur.wb.context.ProcessingContext;
import edu.uchc.connjur.wb.event.WorkflowEvent;
import edu.uchc.connjur.wb.event.WorkflowListener;
import edu.uchc.connjur.wb.gui.ComboActorChooser;
import edu.uchc.connjur.wb.gui.ElementVisual;
import edu.uchc.connjur.wb.gui.FontChooser;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.Menu;
import edu.uchc.connjur.wb.gui.SearchWorkflow;
import edu.uchc.connjur.wb.gui.WorkflowCanvas;
import edu.uchc.connjur.wb.gui.component.CreateWorkflow;
import edu.uchc.connjur.wb.gui.component.ManageChildrenEnabledPanel;
import edu.uchc.connjur.wb.gui.component.RunPopup;
import edu.uchc.connjur.wb.st.FileSystemLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SpectralReconstructionPane
extends JPanel
implements Menu.Client,
WorkflowCanvas.CanvasClient,
WorkflowListener,
Runnable,
RunPopup.Client {
    private Menu.Provider menuProvider;
    private JButton addActorButton;
    private JLabel actorLabel;
    private ComboActorChooser comboActorChooser;
    private JComboBox zoomCombo;
    private JToolBar workflowToolBar;
    private JPanel actorPanel;
    private JButton addStrandButton;
    private JComboBox strandCombo;
    private JPanel strandPanel;
    private JScrollPane srWorkflow;
    private Workflow workflow;
    private WorkflowCanvas workflowCanvas;
    private JProgressBar memoryBar;
    private JButton runButton;
    private JButton ceaseButton;
    private JButton fontChooseButton;
    private NodeForActor currentActorNode = null;
    private RunPopup runPopup;
    private Strand strandCopy;
    private boolean checkRunState = false;
    private static Menu[] actorMenuItems = new Menu[]{Menu.DELETE, Menu.COPY, Menu.CUT, Menu.PASTE};
    public static final GraphicLogger lg = GraphicLogger.getLogger(SpectralReconstructionPane.class);
    public static String DELETE_BINDING = "delete";
    private boolean running = false;

    public SpectralReconstructionPane() {
        this.initGUI();
        this.repaint();
        InputMap imap = this.getInputMap(1);
        KeyStroke delete = KeyStroke.getKeyStroke("DELETE");
        imap.put(delete, DELETE_BINDING);
        this.getActionMap().put(DELETE_BINDING, new DeleteAction());
    }

    private void initGUI() {
        try {
            BorderLayout superLayout = new BorderLayout();
            super.setLayout(superLayout);
            this.srWorkflow = new JScrollPane();
            super.add((Component)this.srWorkflow, "Center");
            super.add((Component)this.getWorkflowToolBar(), "North");
            this.srWorkflow.setViewportView(this.getWorkflowCanvas());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createWorkflow() {
        JFrame owner;
        CreateWorkflow cw;
        FileSystemLoader fl;
        this.workflowCanvas.init();
        if (lg.isGraphicsEnabled()) {
            lg.graphics("open file loader dialog");
        }
        if ((fl = (cw = new CreateWorkflow(owner = (JFrame)SwingUtilities.getAncestorOfClass(Frame.class, this))).getSelectedLoader()) != null) {
            this.setWorkflow(new Workflow(fl.createAnother()));
            this.getWorkflowCanvas().setRoot(this.workflow.getRoot());
        }
        this.repaint();
        this.menuProvider.setEnabled(Menu.SAVE, true);
    }

    private void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
        workflow.addWorkflowListener((WorkflowListener)this);
    }

    public void workflowChanged(WorkflowEvent event) {
        if (event.getWorkflow() != this.workflow) {
            assert (false);
            return;
        }
        this.checkRunState = true;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        if (this.checkRunState) {
            this.setMenus();
        }
        this.checkRunState = false;
    }

    WorkflowCanvas getWorkflowCanvas() {
        if (this.workflowCanvas == null) {
            this.workflowCanvas = new WorkflowCanvas(this, this);
            this.workflowCanvas.setOpaque(true);
            this.workflowCanvas.setBackground(Color.WHITE);
        }
        return this.workflowCanvas;
    }

    private JToolBar getWorkflowToolBar() {
        this.workflowToolBar = new JToolBar();
        this.actorLabel = new JLabel("Add actor:");
        this.comboActorChooser = new ComboActorChooser();
        this.addActorButton = new JButton();
        this.addActorButton.setText("Add");
        this.addActorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectralReconstructionPane.this.addActorPressed(evt);
            }
        });
        this.actorPanel = new ManageChildrenEnabledPanel();
        this.actorPanel.add(this.actorLabel);
        this.actorPanel.add(this.comboActorChooser);
        this.actorPanel.add(this.addActorButton);
        this.actorPanel.setEnabled(false);
        this.addStrandButton = new JButton("Add");
        this.addStrandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectralReconstructionPane.this.addStrandButton.repaint();
                SwingUtilities.invokeLater(new AddStrand());
            }
        });
        this.strandCombo = new JComboBox();
        this.strandCombo.setEditable(false);
        this.strandCombo.setModel(new DefaultComboBoxModel());
        this.strandPanel = new ManageChildrenEnabledPanel();
        this.strandPanel.add(new JLabel("Add strand:"));
        this.strandPanel.add(this.strandCombo);
        this.strandPanel.add(this.addStrandButton);
        this.strandPanel.setEnabled(false);
        JLabel zoomLabel = new JLabel("Zoom:");
        JPanel zoomPanel = new JPanel();
        zoomPanel.add(zoomLabel);
        zoomPanel.add(this.getZoomCombo());
        this.workflowToolBar.add(this.actorPanel);
        this.workflowToolBar.add(this.strandPanel);
        this.workflowToolBar.add(zoomPanel);
        this.workflowToolBar.add(this.getMemoryBar());
        this.workflowToolBar.add(this.getFontChooseButton());
        this.workflowToolBar.add(this.getRunButton());
        this.ceaseButton = new JButton();
        this.ceaseButton.setText("Stop");
        this.ceaseButton.setEnabled(false);
        this.ceaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SpectralReconstructionPane.this.ceaseRunning();
            }
        });
        this.workflowToolBar.add(this.ceaseButton);
        return this.workflowToolBar;
    }

    private void setStrandCombo(NodeForPortfolio nfp) {
        assert (this.strandCombo != null);
        DefaultComboBoxModel mdl = (DefaultComboBoxModel)this.strandCombo.getModel();
        mdl.removeAllElements();
        DataElement de = nfp.getPortfolio().getCurrentDataElement();
        ProcessingContextImpl pc = new ProcessingContextImpl(de);
        boolean shouldEnable = false;
        StrandCatalog sc = StrandCatalog.get();
        for (Strand s : sc.getList()) {
            if (!s.canApply((ProcessingContext)pc)) continue;
            mdl.addElement(s.getName());
            shouldEnable = true;
        }
        this.strandPanel.setEnabled(shouldEnable);
    }

    public JComboBox getZoomCombo() {
        if (this.zoomCombo == null) {
            String[] list = new String[]{"25%", "50%", "75%", "100%", "150%", "200%", "300%", "400%"};
            DefaultComboBoxModel<String> zoomComboModel = new DefaultComboBoxModel<String>(list);
            zoomComboModel.setSelectedItem("100%");
            this.zoomCombo = new JComboBox();
            this.zoomCombo.setModel(zoomComboModel);
            this.zoomCombo.setEditable(true);
            this.zoomCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpectralReconstructionPane.this.zoomComboActionPerformed(evt);
                }
            });
        }
        return this.zoomCombo;
    }

    private void zoomComboActionPerformed(ActionEvent evt) {
        JComboBox jcb = this.getZoomCombo();
        Integer value = SpectralReconstructionPane.validateZoomString((String)jcb.getSelectedItem());
        if (lg.isGraphicsEnabled()) {
            lg.graphics(jcb.getSelectedItem());
        }
        if (value != null) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("setting zoom  " + value + '%');
            }
            WorkflowCanvas wc = this.getWorkflowCanvas();
            wc.setScale(value.doubleValue() / 100.0);
            wc.repaint();
        } else {
            long scale = Math.round(this.getWorkflowCanvas().getScale() * 100.0);
            jcb.setSelectedItem(Long.toString(scale) + '%');
        }
    }

    public static Integer validateZoomString(String entered) {
        String stripped = entered.replace('%', ' ').trim();
        try {
            return Integer.parseInt(stripped);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void portfolioSelected(NodeForPortfolio node, boolean exclusive, boolean single) {
        for (Menu m : actorMenuItems) {
            this.menuProvider.setEnabled(m, false);
        }
        if (single) {
            this.setStrandCombo(node);
            this.comboActorChooser.setSelected(node);
            this.actorPanel.setEnabled(true);
            this.menuProvider.setEnabled(Menu.PASTE, this.canPaste(node, this.strandCopy));
        } else {
            this.comboActorChooser.clearSelected();
            this.actorPanel.setEnabled(false);
            this.menuProvider.setEnabled(Menu.PASTE, false);
            this.strandPanel.setEnabled(false);
        }
    }

    private boolean canPaste(NodeForPortfolio node, Strand strand) {
        if (strand != null) {
            DataElement de = node.getPortfolio().getCurrentDataElement();
            ProcessingContextImpl pc = new ProcessingContextImpl(de);
            return strand.canApply((ProcessingContext)pc);
        }
        return false;
    }

    @Override
    public void actorElementSelected(NodeForActor node, boolean exclusive, boolean single) {
        boolean canCopy = false;
        this.comboActorChooser.clearSelected();
        this.actorPanel.setEnabled(false);
        this.strandPanel.setEnabled(false);
        if (single) {
            this.currentActorNode = node;
            if (!(this.currentActorNode instanceof NodeForLoader)) {
                for (Menu m : actorMenuItems) {
                    this.menuProvider.setEnabled(m, true);
                }
            }
        } else {
            this.currentActorNode = null;
        }
        if (exclusive && Strand.canConstruct(this.workflowCanvas.getSelected())) {
            canCopy = true;
        }
        this.menuProvider.setEnabled(Menu.COPY, canCopy);
        this.menuProvider.setEnabled(Menu.CUT, canCopy);
        this.menuProvider.setEnabled(Menu.PASTE, false);
    }

    @Override
    public void selectionCleared() {
        this.comboActorChooser.clearSelected();
        this.actorPanel.setEnabled(false);
        this.strandPanel.setEnabled(false);
        this.currentActorNode = null;
        for (Menu m : actorMenuItems) {
            this.menuProvider.setEnabled(m, false);
        }
        this.menuProvider.setEnabled(Menu.PASTE, false);
    }

    private void addActorPressed(ActionEvent evt) {
        FlowActor actor = this.comboActorChooser.getSelectedActor();
        FlowActor newActor = actor.createAnother();
        NodeForPortfolio node = this.comboActorChooser.getNode();
        node.add(newActor);
        this.workflow.validateTree();
    }

    private JButton getFontChooseButton() {
        if (this.fontChooseButton == null) {
            this.fontChooseButton = new JButton();
            this.fontChooseButton.setText("Choose Font");
            this.fontChooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpectralReconstructionPane.this.chooseFont(evt);
                }
            });
        }
        return this.fontChooseButton;
    }

    private JButton getRunButton() {
        if (this.runButton == null) {
            this.runButton = new JButton();
            this.runButton.setText("Run");
            this.runButton.setEnabled(false);
            this.runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpectralReconstructionPane.this.runButtonActionPerformed(evt);
                }
            });
        }
        return this.runButton;
    }

    private void chooseFont(ActionEvent evt) {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        Font f = FontChooser.chooseFont((Frame)parent, ElementVisual.getFont());
        if (f != null) {
            ElementVisual.setFont(f);
            this.getWorkflowCanvas().invalidateAllVisuals();
        }
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        this.menuRun();
    }

    @Override
    public void menuRun() {
        if (this.running) {
            return;
        }
        this.running = true;
        lg.graphics("run button pressed");
        assert (this.workflow != null);
        assert (this.workflow.isCanRun());
        this.workflowCanvas.setDisableInteraction(true);
        boolean actorPanelEnabled = this.actorPanel.isEnabled();
        this.actorPanel.setEnabled(false);
        this.setMenus();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.setCursor(waitCursor);
        BunchOfThreads bunch = this.workflow.run();
        Thread waitingThread = new Thread(new RunWaiter(bunch, actorPanelEnabled));
        this.runPopup = new RunPopup(this, this);
        this.runPopup.show();
        waitingThread.start();
    }

    private void ceaseRunning() {
        if (this.workflow != null) {
            this.workflow.ceaseRunning();
        }
    }

    @Override
    public void stop() {
        this.ceaseRunning();
    }

    private void runComplete(boolean actorPanelWasActive) {
        this.running = false;
        Cursor defaultCursor = Cursor.getPredefinedCursor(0);
        this.setCursor(defaultCursor);
        this.setMenus();
        this.workflowCanvas.setDisableInteraction(false);
        this.actorPanel.setEnabled(actorPanelWasActive);
        this.runPopup.hide();
    }

    @Override
    public void clearWorkflow() {
        this.workflow = null;
        this.workflowCanvas.setRoot(null);
        this.setMenus();
    }

    private void setMenus() {
        boolean haveWorkflow = this.workflow != null;
        this.menuProvider.setEnabled(Menu.NEW, !this.running);
        this.menuProvider.setEnabled(Menu.OPEN, !this.running);
        boolean canRun = haveWorkflow && this.workflow.isCanRun() && !this.running;
        this.runButton.setEnabled(canRun);
        this.menuProvider.setEnabled(Menu.RUN, canRun);
        this.ceaseButton.setEnabled(this.running);
        this.menuProvider.setEnabled(Menu.SAVE, !this.running && this.isWorkflowDirty());
        if (!haveWorkflow) {
            this.selectionCleared();
        }
    }

    private boolean isWorkflowDirty() {
        return this.workflow != null && this.workflow.canBeSaved();
    }

    @Override
    public void activate(Menu.Provider provider) {
        this.menuProvider = provider;
        this.setMenus();
        this.buildRecentMenu();
    }

    @Override
    public void dropDown(Menu.Provider provider, Menu item) {
        if (item == Menu.FILE) {
            this.setMenus();
        }
    }

    private boolean checkForSave() {
        if (!this.isWorkflowDirty()) {
            return true;
        }
        int choice = JOptionPane.showConfirmDialog(this, "Existing workflow not saved to database. Save before proceeding?", "Workflow not saved", 1);
        switch (choice) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
            case 0: {
                this.menuSave();
                return true;
            }
        }
        assert (false);
        return false;
    }

    @Override
    public void menuNew() {
        if (this.checkForSave()) {
            this.createWorkflow();
        }
    }

    @Override
    public void menuOpen() {
        this.workflowCanvas.init();
        if (this.checkForSave()) {
            Cursor current = this.getCursor();
            Frame owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
            assert (owner != null);
            SearchWorkflow sw = new SearchWorkflow(owner);
            Workflow wf = sw.openWorkflow(this);
            lg.graphics("Workflow opened " + wf);
            this.justOpenedWorkflow(wf);
            this.setCursor(current);
            this.buildRecentMenu();
        }
    }

    private void justOpenedWorkflow(Workflow wf) {
        if (wf != null) {
            this.setWorkflow(wf);
            this.getWorkflowCanvas().setRoot(this.workflow.getRoot());
            this.repaint();
            this.menuProvider.setEnabled(Menu.SAVE, true);
        }
        this.setMenus();
    }

    @Override
    public void menuSave() {
        assert (this.workflow != null);
        long start = 0L;
        if (lg.isInfoEnabled()) {
            start = System.currentTimeMillis();
            lg.info("start save");
        }
        Cursor current = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.workflow.save();
        this.setCursor(current);
        if (lg.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            double time = (double)(start - end) / 1000.0;
            lg.info("finish save, elapsed time " + time + " seconds");
        }
        this.buildRecentMenu();
    }

    @Override
    public void editDelete() {
        Collection<WorkflowNode> selected = this.workflowCanvas.getSelected();
        NodeForActor head = Strand.getHead(selected);
        head.getActorElement().setDelete(true, false);
    }

    @Override
    public void editCopy() {
        Collection<WorkflowNode> selected = this.workflowCanvas.getSelected();
        assert (Strand.canConstruct(selected)) : "SpectralReconstructionPane.editCopy";
        this.strandCopy = new Strand(selected);
    }

    @Override
    public void editCut() {
        this.editCopy();
        this.editDelete();
    }

    private NodeForPortfolio getSelectedPortofolio() {
        Collection<WorkflowNode> selected = this.workflowCanvas.getSelected();
        assert (selected.size() == 1);
        Iterator<WorkflowNode> iter = selected.iterator();
        assert (iter.hasNext());
        WorkflowNode node = iter.next();
        assert (node instanceof NodeForPortfolio) : "SpectralReconstructionPanel.editPaste selected node not NodeForPortfolio";
        NodeForPortfolio nfp = (NodeForPortfolio)node;
        return nfp;
    }

    @Override
    public void editPaste() {
        assert (this.strandCopy != null) : "SpectralReconstructionPanel.editPaste active with nothing copied";
        NodeForPortfolio nfp = this.getSelectedPortofolio();
        this.strandCopy.apply(nfp);
    }

    private void addStrandPressed() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        NodeForPortfolio nfp = this.getSelectedPortofolio();
        StrandCatalog sc = StrandCatalog.get();
        String strandName = (String)this.strandCombo.getSelectedItem();
        Strand s = sc.lookup(strandName);
        s.apply(nfp);
        this.setCursor(oldCursor);
    }

    private JProgressBar getMemoryBar() {
        if (this.memoryBar == null) {
            this.memoryBar = new JProgressBar();
            this.updateMemoryBar();
            new Timer(5000, new UpdateAction()).start();
        }
        return this.memoryBar;
    }

    private void buildRecentMenu() {
        JMenu recentMenu = this.menuProvider.recentMenu();
        recentMenu.removeAll();
        Iterator rwi = Workflow.getLastSaved();
        if (!rwi.hasNext()) {
            this.menuProvider.setEnabled(Menu.RECENT, false);
            return;
        }
        this.menuProvider.setEnabled(Menu.RECENT, true);
        while (rwi.hasNext()) {
            WorkflowBase.RecentWorkflow recentWorkflow = (WorkflowBase.RecentWorkflow)rwi.next();
            RecentlyUsedMenuItem jmi = new RecentlyUsedMenuItem(recentWorkflow);
            recentMenu.add(jmi);
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpectralReconstructionPane.this.openRecentSelected(e);
                }
            });
        }
    }

    private void openRecentSelected(ActionEvent e) {
        if (!this.checkForSave()) {
            return;
        }
        RecentlyUsedMenuItem lsmi = (RecentlyUsedMenuItem)e.getSource();
        Cursor current = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Workflow wf = SearchWorkflow.openWorkflow(lsmi.lastSaved.id);
        this.justOpenedWorkflow(wf);
        if (wf == null) {
            JOptionPane.showMessageDialog(this, "Workflow " + lsmi.lastSaved + " not longer present in database", "Workflow has been deleted", 1);
        }
        this.setCursor(current);
    }

    @Override
    public void menuScreenshot() {
        double linearScale;
        String answer = JOptionPane.showInputDialog("Enter scale factor, floating point number > 1. " + CodeUtil.NEWLINE + "This is the amount the area of the image is multipled. " + CodeUtil.NEWLINE + "Image will be saved as \"screenshot.png\", overwriting any existing file." + CodeUtil.NEWLINE + " Might take a while. A message dialog will appear when complete");
        try {
            double areaIncrease = Double.parseDouble(answer);
            linearScale = Math.sqrt(areaIncrease);
        }
        catch (Exception nfe) {
            JOptionPane.showMessageDialog(this, "Didn't understand " + answer);
            return;
        }
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        int height = this.workflowCanvas.getHeight();
        int width = this.workflowCanvas.getWidth();
        double oldScale = this.workflowCanvas.getScale();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int canvasHeight = (int)((double)height * linearScale);
        int canvasWidth = (int)((double)width * linearScale);
        BufferedImage bi = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics2D g2d = ge.createGraphics(bi);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, canvasWidth, canvasHeight);
        this.workflowCanvas.overrideHeight(canvasHeight);
        this.workflowCanvas.setScale(linearScale);
        this.workflowCanvas.paint(g2d);
        File dump = new File("screenshot.png");
        try {
            ImageIO.write((RenderedImage)bi, "png", dump);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.workflowCanvas.clearOverride();
        this.workflowCanvas.setScale(oldScale);
        this.setCursor(oldCursor);
        JOptionPane.showMessageDialog(this, "Screenshot complete");
    }

    private void updateMemoryBar() {
        int limit;
        int inUse;
        this.memoryBar.setBackground(Color.WHITE);
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long max = rt.maxMemory();
        long notAllocatedYet = max - rt.totalMemory();
        free += notAllocatedYet;
        if (max > Integer.MAX_VALUE) {
            double scale = 2.147483647E9 / (double)max;
            max = (long)((double)max * scale);
            free = (long)((double)free * scale);
        }
        if ((inUse = (int)(max - free)) < (limit = (int)(0.8 * (double)max))) {
            this.memoryBar.setForeground(Color.GREEN);
        } else {
            this.memoryBar.setForeground(Color.RED);
        }
        this.memoryBar.setMinimum(0);
        this.memoryBar.setMaximum((int)max);
        this.memoryBar.setValue(inUse);
        System.gc();
    }

    private static class RecentlyUsedMenuItem
    extends JMenuItem {
        final WorkflowBase.RecentWorkflow lastSaved;

        public RecentlyUsedMenuItem(WorkflowBase.RecentWorkflow lastSaved) {
            this.lastSaved = lastSaved;
            this.setText(lastSaved.toString());
        }
    }

    private class AddStrand
    implements Runnable {
        private AddStrand() {
        }

        @Override
        public void run() {
            SpectralReconstructionPane.this.addStrandPressed();
        }
    }

    private class UpdateAction
    extends AbstractAction {
        private UpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SpectralReconstructionPane.this.updateMemoryBar();
        }
    }

    private class RunWaiter
    implements Runnable {
        BunchOfThreads bunch;
        boolean actorPanelWasActive;

        public RunWaiter(BunchOfThreads bunch, boolean actorPanelWasActive) {
            this.bunch = bunch;
            assert (bunch != null);
            this.actorPanelWasActive = actorPanelWasActive;
        }

        @Override
        public void run() {
            this.bunch.waitForAll();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpectralReconstructionPane.this.runComplete(RunWaiter.this.actorPanelWasActive);
                }
            });
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (SpectralReconstructionPane.this.currentActorNode != null) {
                SpectralReconstructionPane.this.editDelete();
            }
        }
    }
}

