/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.ActorElement;
import edu.uchc.connjur.wb.NonPersistentActorElement;
import edu.uchc.connjur.wb.Workflow;
import edu.uchc.connjur.wb.actor.prefs.DatabaseSelectionActor;
import edu.uchc.connjur.wb.actor.prefs.GeneralPreferencesActor;
import edu.uchc.connjur.wb.actor.prefs.ToolLocationActor;
import edu.uchc.connjur.wb.event.WorkflowEvent;
import edu.uchc.connjur.wb.event.WorkflowListener;
import edu.uchc.connjur.wb.gui.ActorConfigurationEditor;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.ImageFactory;
import edu.uchc.connjur.wb.gui.LogWindow;
import edu.uchc.connjur.wb.gui.Menu;
import edu.uchc.connjur.wb.gui.SpectralReconstructionPane;
import edu.uchc.connjur.wb.gui.component.About;
import edu.uchc.connjur.wb.gui.component.ColorPreferences;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.io.IOUtils;

public class WorkflowBuilder
extends JFrame
implements Menu.Provider,
WorkflowListener {
    public static final String LOOK_AND_FEEL_KEY = "lookAndFeel";
    public static final String DATABASE_INSTALL_SCRIPT = "installWB.sql";
    public static final String CONNJUR_WEB_ROOT = "http://www.connjur.com/";
    public static String currentPostRoot = null;
    private JMenuItem helpMenuItem;
    private JMenu jMenu5;
    private JMenu prefMenu;
    private JMenu recentMenu;
    private JMenuItem dbInstallItem;
    private JMenuItem feedbackMenu;
    private SpectralReconstructionPane srPanel;
    private JCheckBoxMenuItem logWindowCheckMenu;
    private JPanel widgetPanel;
    private JTabbedPane mainPane;
    private JMenuItem deleteMenuItem;
    private JSeparator jSeparator1;
    private JMenuItem pasteMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenu jMenu4;
    private JMenuItem exitMenuItem;
    private JSeparator jSeparator2;
    private JMenuItem newFileMenuItem;
    private JMenuItem openFileMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem runMenuItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem colorMenuItem;
    private JMenuItem databaseMenuItem;
    private JMenuItem toolMenuItem;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JMenu lookAndFeelMenu;
    private LogWindow logWindow = null;
    private Menu.Client currentClient;
    public static final GraphicLogger lg = GraphicLogger.getLogger(WorkflowBuilder.class);

    public WorkflowBuilder() {
        this.initGUI();
        this.buildLookAndFeelMenu();
        this.repaint();
        if (lg.isInfoEnabled()) {
            this.logWindowCheckMenu.setSelected(true);
            this.getLogWindow().activate();
        }
        this.mainPane.setSelectedComponent(this.srPanel);
        Image img = ImageFactory.get().getLogoImage();
        super.setIconImage(img);
        Workflow.addClassListener((WorkflowListener)this);
    }

    private void initGUI() {
        try {
            this.setTitle("New CONNJUR Workflow Builder");
            this.jMenuBar1 = new JMenuBar();
            this.setJMenuBar(this.jMenuBar1);
            this.fileMenu = new JMenu();
            this.fileMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent arg0) {
                    WorkflowBuilder.this.currentClient.dropDown(WorkflowBuilder.this, Menu.FILE);
                }

                @Override
                public void menuCanceled(MenuEvent arg0) {
                }

                @Override
                public void menuDeselected(MenuEvent arg0) {
                }
            });
            this.jMenuBar1.add(this.fileMenu);
            this.fileMenu.setText("File");
            this.newFileMenuItem = new JMenuItem();
            this.fileMenu.add(this.newFileMenuItem);
            this.newFileMenuItem.setText("New");
            this.newFileMenuItem.setEnabled(true);
            this.newFileMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.currentClient.menuNew();
                }
            });
            this.openFileMenuItem = new JMenuItem();
            this.fileMenu.add(this.openFileMenuItem);
            this.openFileMenuItem.setText("Open");
            this.openFileMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.currentClient.menuOpen();
                }
            });
            this.recentMenu = new JMenu("Open recent");
            this.fileMenu.add(this.recentMenu);
            this.saveMenuItem = new JMenuItem();
            this.fileMenu.add(this.saveMenuItem);
            this.saveMenuItem.setText("Save");
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.currentClient.menuSave();
                }
            });
            this.runMenuItem = new JMenuItem("Run");
            this.fileMenu.add(this.runMenuItem);
            this.runMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.currentClient.menuRun();
                }
            });
            this.jSeparator2 = new JSeparator();
            this.fileMenu.add(this.jSeparator2);
            if (System.getProperty("screenshot") != null) {
                JMenuItem jmi = new JMenuItem("Screenshot workflow canvas ...");
                this.fileMenu.add(jmi);
                this.fileMenu.add(new JSeparator());
                jmi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WorkflowBuilder.this.currentClient.menuScreenshot();
                    }
                });
            }
            this.exitMenuItem = new JMenuItem();
            this.fileMenu.add(this.exitMenuItem);
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    System.exit(0);
                }
            });
            this.jMenu4 = new JMenu();
            this.jMenuBar1.add(this.jMenu4);
            this.prefMenu = new JMenu();
            this.prefMenu.setText("Preferences");
            this.colorMenuItem = new JMenuItem();
            this.colorMenuItem.setText("Set colors...");
            this.colorMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.showColor();
                }
            });
            JMenuItem generalPref = new JMenuItem("General preferences ...");
            generalPref.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.setGeneralPref();
                }
            });
            this.databaseMenuItem = new JMenuItem("Select database ...");
            this.databaseMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.selectDatabase();
                }
            });
            this.toolMenuItem = new JMenuItem("Set tool locations ...");
            this.toolMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.selectTool();
                }
            });
            this.prefMenu.add(generalPref);
            this.prefMenu.add(this.colorMenuItem);
            this.prefMenu.add(this.databaseMenuItem);
            this.prefMenu.add(this.toolMenuItem);
            this.jMenuBar1.add(this.prefMenu);
            this.jMenu4.setText("Edit");
            this.cutMenuItem = new JMenuItem("Cut");
            this.jMenu4.add(this.cutMenuItem);
            this.cutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkflowBuilder.this.currentClient.editCut();
                }
            });
            this.copyMenuItem = new JMenuItem("Copy");
            this.jMenu4.add(this.copyMenuItem);
            this.copyMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkflowBuilder.this.currentClient.editCopy();
                }
            });
            this.pasteMenuItem = new JMenuItem("Paste");
            this.jMenu4.add(this.pasteMenuItem);
            this.pasteMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkflowBuilder.this.currentClient.editPaste();
                }
            });
            this.jSeparator1 = new JSeparator();
            this.jMenu4.add(this.jSeparator1);
            this.deleteMenuItem = new JMenuItem("Delete");
            this.jMenu4.add(this.deleteMenuItem);
            this.deleteMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkflowBuilder.this.currentClient.editDelete();
                }
            });
            this.jMenu5 = new JMenu();
            this.jMenuBar1.add(this.jMenu5);
            this.jMenu5.setText("Help");
            this.helpMenuItem = new JMenuItem();
            this.helpMenuItem.setText("Help");
            this.jMenu5.add(this.helpMenuItem);
            this.helpMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    WorkflowBuilder.this.openHelpPage();
                }
            });
            this.feedbackMenu = new JMenuItem();
            this.feedbackMenu.setText("Send CONNJUR feedback...");
            this.feedbackMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.openFeedbackPage();
                }
            });
            this.jMenu5.add(this.feedbackMenu);
            this.dbInstallItem = new JMenuItem();
            this.dbInstallItem.setText("Database Install Script ...");
            this.dbInstallItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.saveInstallScript(evt);
                }
            });
            this.jMenu5.add(this.dbInstallItem);
            if (System.getProperty("SHOWLOGWINDOW") != null) {
                this.logWindowCheckMenu = new JCheckBoxMenuItem();
                this.logWindowCheckMenu.setText("Java Log Window");
                this.logWindowCheckMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        WorkflowBuilder.this.logToggled(evt);
                    }
                });
                this.jMenu5.add(this.logWindowCheckMenu);
            }
            this.aboutMenuItem = new JMenuItem();
            this.jMenu5.add(this.aboutMenuItem);
            this.aboutMenuItem.setText("About...");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WorkflowBuilder.this.showAbout();
                }
            });
            this.mainPane = new JTabbedPane();
            this.srPanel = new SpectralReconstructionPane();
            this.getContentPane().add((Component)this.mainPane, "Center");
            this.mainPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    WorkflowBuilder.this.mainPaneStateChanged(evt);
                }
            });
            this.mainPane.addTab("SR", null, this.srPanel, null);
            this.widgetPanel = new JPanel();
            this.getContentPane().add((Component)this.widgetPanel, "South");
            this.setSize(400, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showAbout() {
        Frame owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        About aboutDialog = new About(owner);
        aboutDialog.setVisible(true);
    }

    protected void showColor() {
        Frame owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        ColorPreferences dialog = new ColorPreferences(owner);
        dialog.setVisible(true);
    }

    private LogWindow getLogWindow() {
        if (this.logWindow != null) {
            return this.logWindow;
        }
        this.logWindow = new LogWindow();
        this.logWindow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                WorkflowBuilder.this.logWindowCheckMenu.setSelected(false);
            }
        });
        return this.logWindow;
    }

    private void logToggled(ActionEvent evt) {
        if (this.logWindowCheckMenu.isSelected()) {
            this.getLogWindow().activate();
        } else {
            this.getLogWindow().deactivate();
        }
    }

    @Override
    public void setEnabled(Menu option, boolean enabled) {
        switch (option) {
            case FILE: {
                break;
            }
            case NEW: {
                this.newFileMenuItem.setEnabled(enabled);
                break;
            }
            case OPEN: {
                this.openFileMenuItem.setEnabled(enabled);
                break;
            }
            case RECENT: {
                this.recentMenu.setEnabled(enabled);
                break;
            }
            case SAVE: {
                this.saveMenuItem.setEnabled(enabled);
                break;
            }
            case CUT: {
                this.cutMenuItem.setEnabled(enabled);
                break;
            }
            case COPY: {
                this.copyMenuItem.setEnabled(enabled);
                break;
            }
            case PASTE: {
                this.pasteMenuItem.setEnabled(enabled);
                break;
            }
            case DELETE: {
                this.deleteMenuItem.setEnabled(enabled);
                break;
            }
            case RUN: {
                this.runMenuItem.setEnabled(enabled);
                break;
            }
            default: {
                assert (false) : "Unsupported switch option";
                break;
            }
        }
    }

    @Override
    public JMenu recentMenu() {
        return this.recentMenu;
    }

    private void mainPaneStateChanged(ChangeEvent evt) {
        Component component = this.mainPane.getSelectedComponent();
        assert (component instanceof Menu.Client);
        this.currentClient = (Menu.Client)((Object)component);
        this.currentClient.activate(this);
        if (lg.isInfoEnabled()) {
            lg.graphics("Panel " + component.getName() + " activated");
        }
    }

    private void buildLookAndFeelMenu() {
        UIManager.LookAndFeelInfo[] infos;
        this.lookAndFeelMenu = new JMenu("Set look and feel");
        String current = UIManager.getLookAndFeel().getName();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = infos = UIManager.getInstalledLookAndFeels();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lafi = lookAndFeelInfoArray[n2];
            String lafName = lafi.getName();
            boolean isCurrent = current.equals(lafName);
            JCheckBoxMenuItem jmi = new JCheckBoxMenuItem(lafi.getName(), isCurrent);
            this.lookAndFeelMenu.add(jmi);
            jmi.addActionListener(new LookAndFeelRecorder(lafi));
            ++n2;
        }
        this.prefMenu.add(this.lookAndFeelMenu);
    }

    private void saveInstallScript(ActionEvent evt) {
        ClassLoader loader = Actor.class.getClassLoader();
        InputStream fis = loader.getResourceAsStream(DATABASE_INSTALL_SCRIPT);
        if (fis == null) {
            throw new RuntimeException("WorkflowBuilder.saveInstallScript bad program construction");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(new File(DATABASE_INSTALL_SCRIPT));
        int rc = chooser.showDialog(this, "Save install script");
        if (rc == 0) {
            try {
                File output = chooser.getSelectedFile();
                FileOutputStream fos = new FileOutputStream(output);
                IOUtils.copy((InputStream)fis, (OutputStream)fos);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error saving file " + e.getMessage(), "Error", 0);
            }
        }
    }

    public void openFeedbackPage() {
        WorkflowBuilder.openCONNJURPage(this, "feedback", null);
    }

    public void openHelpPage() {
        WorkflowBuilder.openURL("http://www.connjur.com/wbhelp/");
    }

    public static void openCONNJURPage(Component owner, String reason, Map<String, String> content) {
        if (currentPostRoot == null) {
            WorkflowBuilder.readPostUrl();
        }
        try {
            URL url = new URL(String.valueOf(currentPostRoot) + "/feedback/key.php");
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
            printout.writeBytes("reason=");
            printout.writeBytes(reason);
            if (content != null) {
                for (String key : content.keySet()) {
                    printout.writeBytes("&");
                    printout.writeBytes(URLEncoder.encode(key, "UTF-8"));
                    printout.writeBytes("=");
                    String value = content.get(key);
                    printout.writeBytes(URLEncoder.encode(value, "UTF-8"));
                }
            }
            printout.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            String sid = input.readLine();
            String key = input.readLine();
            String value = input.readLine();
            input.close();
            StringBuilder sb = new StringBuilder();
            sb.append("http://www.connjur.com/feedback/feedback.php?SID=");
            sb.append(sid);
            sb.append("&key=");
            sb.append(key);
            sb.append("&value=");
            sb.append(value);
            String urlString = sb.toString();
            WorkflowBuilder.openURL(urlString);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(owner, "Unable to contact feedback website. Please visit http://www.connjur.com/ to leave us feedback.", "Automatic contact failed", 2);
        }
    }

    public static void readPostUrl() {
        try {
            URL url = new URL("http://www.connjur.com/rooturl");
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            BufferedReader input = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            currentPostRoot = input.readLine();
        }
        catch (Exception e) {
            currentPostRoot = "http://connjur.uchc.edu/";
        }
    }

    private void selectDatabase() {
        DatabaseSelectionActor dsa = new DatabaseSelectionActor();
        NonPersistentActorElement npae = new NonPersistentActorElement((Actor)dsa);
        ActorConfigurationEditor ace = new ActorConfigurationEditor((Frame)this, this);
        ace.setActorElement((ActorElement)npae, null);
        ace.setVisible(true);
    }

    private void setGeneralPref() {
        GeneralPreferencesActor gpa = new GeneralPreferencesActor();
        NonPersistentActorElement npae = new NonPersistentActorElement((Actor)gpa);
        ActorConfigurationEditor ace = new ActorConfigurationEditor((Frame)this, this);
        ace.setActorElement((ActorElement)npae, null);
        ace.setVisible(true);
    }

    public void workflowChanged(WorkflowEvent event) {
        this.databaseMenuItem.setEnabled(false);
        Workflow.removeClassListener((WorkflowListener)this);
    }

    private void selectTool() {
        ToolLocationActor tla = new ToolLocationActor();
        NonPersistentActorElement npae = new NonPersistentActorElement((Actor)tla);
        ActorConfigurationEditor ace = new ActorConfigurationEditor((Frame)this, this);
        ace.setActorElement((ActorElement)npae, null);
        ace.setVisible(true);
    }

    public static void openURL(String url) {
        String errMsg = "Error attempting to launch web browser";
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser\n" + e.toString());
        }
    }

    private class LookAndFeelRecorder
    implements ActionListener {
        private UIManager.LookAndFeelInfo lafi;

        public LookAndFeelRecorder(UIManager.LookAndFeelInfo lafi) {
            this.lafi = lafi;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Preferences node = Preferences.userNodeForPackage(WorkflowBuilder.class);
            node.put(WorkflowBuilder.LOOK_AND_FEEL_KEY, this.lafi.getClassName());
            JOptionPane.showMessageDialog(WorkflowBuilder.this, "Java Look and Feel will be set to " + this.lafi.getName() + " next time Workflow Builder started", "Preference updated", 1);
            Component[] componentArray = WorkflowBuilder.this.lookAndFeelMenu.getMenuComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                JMenuItem jmi = (JMenuItem)c;
                if (!jmi.equals(event.getSource())) {
                    jmi.setSelected(false);
                }
                ++n2;
            }
        }
    }
}

