/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.ExecutionTrace;
import edu.uchc.connjur.wb.LineStringBuilder;
import edu.uchc.connjur.wb.NodeForActor;
import edu.uchc.connjur.wb.NodeForPortfolio;
import edu.uchc.connjur.wb.NodeVisitor;
import edu.uchc.connjur.wb.Workflow;
import edu.uchc.connjur.wb.WorkflowNode;
import edu.uchc.connjur.wb.context.Installation;
import edu.uchc.connjur.wb.event.InstallationEvent;
import edu.uchc.connjur.wb.event.InstallationListener;
import edu.uchc.connjur.wb.event.WorkflowChildAddEvent;
import edu.uchc.connjur.wb.event.WorkflowEvent;
import edu.uchc.connjur.wb.event.WorkflowListener;
import edu.uchc.connjur.wb.gui.ActorConfigurationEditor;
import edu.uchc.connjur.wb.gui.ElementVisual;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.PortfolioViewer;
import edu.uchc.connjur.wb.gui.WorkflowEditor;
import edu.uchc.connjur.wb.gui.component.CanvasHelpPainter;
import edu.uchc.connjur.wb.gui.component.CompoundWorkflowClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class WorkflowCanvas
extends JPanel
implements WorkflowListener {
    public static final int SEPARATION_HEIGHT = 10;
    public static final int SEPARATION_WIDTH = 10;
    private CanvasClient client;
    private WorkflowNode root;
    private HashMap<WorkflowNode, ElementVisual> visuals = new HashMap();
    private ElementFinder elementFinder = new ElementFinder();
    private ActorConfigurationEditor configurationEditor;
    private WorkflowEditor workflowEditor;
    private double scale = 1.0;
    private List<ElementVisual> selected = new ArrayList<ElementVisual>();
    private boolean disableInteraction = false;
    private MouseProcessor mouseProcessor = new MouseProcessor();
    private ElementVisual lastEntered = null;
    private int maxWidthOfAnyElement = 0;
    private Dimension ourDimension = new Dimension();
    private Component sizingComponent;
    private Integer overrideHeight = null;
    PortfolioViewer portfolioViewer = null;
    CanvasHelpPainter chp = null;
    InstallationListener installationListener = new ToolWatcher();
    private static GraphicLogger lg = GraphicLogger.getLogger(WorkflowCanvas.class);

    public WorkflowCanvas(CanvasClient client, Component sizingComponent) {
        this.sizingComponent = sizingComponent;
        if (sizingComponent != null) {
            sizingComponent.addComponentListener(new SizingWindowWatcher());
        }
        this.chp = new CanvasHelpPainter(this);
        this.client = new CompoundWorkflowClient(client, this.chp);
        Dimension preferred = new Dimension(ElementVisual.STANDARD_WIDTH * 12, ElementVisual.STANDARD_HEIGHT * 6);
        this.setPreferredSize(preferred);
        this.addMouseListener(this.mouseProcessor);
        this.addMouseMotionListener(this.mouseProcessor);
        Installation.getInstance().addInstallationListener(this.installationListener);
    }

    public void init() {
        if (this.configurationEditor != null) {
            return;
        }
        JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        this.configurationEditor = null;
        this.workflowEditor = null;
        owner.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (WorkflowCanvas.this.lastEntered != null) {
                    WorkflowCanvas.this.lastEntered.mouseLeft();
                    WorkflowCanvas.this.lastEntered = null;
                }
                if (lg.isGraphicsEnabled()) {
                    lg.graphics("Workflow Canvas deactivated");
                }
            }
        });
    }

    public WorkflowCanvas() {
        this(new CanvasClient(){

            @Override
            public void selectionCleared() {
            }

            @Override
            public void portfolioSelected(NodeForPortfolio node, boolean exclusive, boolean single) {
            }

            @Override
            public void actorElementSelected(NodeForActor node, boolean exclusive, boolean single) {
            }

            @Override
            public void clearWorkflow() {
            }
        }, null);
    }

    public void openWorkflowEditor() {
        if (this.workflowEditor == null) {
            Frame owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
            assert (owner != null);
            this.workflowEditor = new WorkflowEditor(owner, this.client);
        }
        this.workflowEditor.setWorkflow(this.root.getWorkflow());
        this.workflowEditor.setVisible(true);
    }

    public WorkflowNode getRoot() {
        return this.root;
    }

    public void setRoot(WorkflowNode root) {
        if (root == this.root) {
            return;
        }
        this.root = root;
        if (this.root != null) {
            HashMap<WorkflowNode, ElementVisual> oldVisuals = this.visuals;
            this.visuals = new HashMap();
            this.copyVisuals(oldVisuals, root);
            Workflow wf = root.getWorkflow();
            wf.addWorkflowListener((WorkflowListener)this);
            ElementVisual rootVisual = this.getVisual(root);
            this.selected.clear();
            rootVisual.setSelected(true);
            this.selected.add(rootVisual);
            this.arrangeElements();
            if (root instanceof NodeForActor) {
                this.client.actorElementSelected((NodeForActor)root, true, true);
            } else if (root instanceof NodeForPortfolio) {
                this.client.portfolioSelected((NodeForPortfolio)root, true, true);
            }
        } else {
            this.repaint();
        }
    }

    public boolean isDisableInteraction() {
        return this.disableInteraction;
    }

    public void setDisableInteraction(boolean disableInteraction) {
        if (disableInteraction == this.disableInteraction) {
            return;
        }
        this.disableInteraction = disableInteraction;
        if (disableInteraction) {
            this.removeMouseListener(this.mouseProcessor);
            this.removeMouseMotionListener(this.mouseProcessor);
        } else {
            this.addMouseListener(this.mouseProcessor);
            this.addMouseMotionListener(this.mouseProcessor);
        }
    }

    Collection<WorkflowNode> getSelected() {
        ArrayList<WorkflowNode> list = new ArrayList<WorkflowNode>();
        for (ElementVisual ev : this.selected) {
            list.add(ev.getNode());
        }
        return list;
    }

    private void copyVisuals(HashMap<WorkflowNode, ElementVisual> oldVisuals, WorkflowNode node) {
        if (oldVisuals.containsKey(node)) {
            this.visuals.put(node, oldVisuals.get(node));
        }
        for (WorkflowNode child : node.getSuccessors()) {
            this.copyVisuals(oldVisuals, child);
        }
    }

    public void invalidateAllVisuals() {
        if (this.root != null) {
            this.getVisual(this.root).invalidateChildren();
        }
        this.repaint();
    }

    ElementVisual getVisual(WorkflowNode node) {
        if (this.visuals.containsKey(node)) {
            return this.visuals.get(node);
        }
        ElementVisual ev = ElementVisual.visualFor(node, this);
        this.visuals.put(node, ev);
        return ev;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) throws IllegalArgumentException {
        if (this.scale == scale) {
            return;
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("value " + scale + " passed to WorkflowCanvas.setScale not positive");
        }
        this.scale = scale;
        if (this.root != null) {
            ElementVisual rv = this.getVisual(this.root);
            rv.invalidateChildren();
            this.arrangeElements();
        }
        Container frame = SwingUtilities.getAncestorOfClass(Frame.class, this);
        frame.repaint();
    }

    public void overrideHeight(int height) {
        this.overrideHeight = height;
    }

    public void clearOverride() {
        this.overrideHeight = null;
    }

    public Point scale(Point p) {
        p.x = (int)((double)p.x * this.scale);
        p.y = (int)((double)p.y * this.scale);
        return p;
    }

    public Rectangle2D inverseScaled(Rectangle2D in) {
        Rectangle2D rval = (Rectangle2D)in.clone();
        rval.setFrame(in.getX() / this.scale, in.getY() / this.scale, in.getWidth() / this.scale, in.getHeight() / this.scale);
        return rval;
    }

    public Shape scaled(Shape in) {
        AffineTransform transform = AffineTransform.getScaleInstance(this.scale, this.scale);
        return transform.createTransformedShape(in);
    }

    public void workflowChanged(WorkflowEvent event) {
        if (this.root != null && event.getWorkflow() == this.root.getWorkflow()) {
            WorkflowEvent.Reason reason = event.getReason();
            if (lg.isGraphicsEnabled()) {
                lg.graphics("Received workflow event " + reason);
            }
            switch (reason) {
                case CHILD_ADDED: {
                    ElementVisual ev2;
                    WorkflowChildAddEvent caEvent = (WorkflowChildAddEvent)event;
                    for (ElementVisual ev2 : this.selected) {
                        ev2.setSelected(false);
                    }
                    this.selected.clear();
                    WorkflowNode node = caEvent.getChildNode();
                    ev2 = this.getVisual(node);
                    this.selected.add(ev2);
                    ev2.setSelected(true);
                    ev2.notifyClient(this.client, true, true);
                    this.arrangeElements();
                    break;
                }
                case CHILD_REMOVED: {
                    this.arrangeElements();
                }
            }
        }
    }

    public void arrangeElements() {
        if (this.root == null) {
            return;
        }
        this.maxWidthOfAnyElement = 0;
        ElementVisual rootVisual = this.getVisual(this.root);
        rootVisual.rebuildChildrenCollection();
        int childrenHeight = rootVisual.calculateChildrenHeight((int)(this.scale * 10.0));
        int heightToUse = Math.max(childrenHeight, this.sizingComponent.getHeight());
        if (this.overrideHeight != null) {
            heightToUse = this.overrideHeight;
        }
        int middleHeight = heightToUse / 2;
        int scaledMiddleHeight = (int)((double)middleHeight / this.scale);
        rootVisual.setY(scaledMiddleHeight);
        rootVisual.setX(rootVisual.getWidth() / 2);
        if (lg.isGraphicsEnabled()) {
            LineStringBuilder lsb = new LineStringBuilder("arrange children laying out WorkflowCanvas height ");
            lsb.append(this.getHeight());
            lsb.append(" width ").append(this.getWidth()).newline();
            lsb.append("children height ").append(childrenHeight).newline();
            if (this.overrideHeight != null) {
                lsb.append("sizing component ").append(ExecutionTrace.justClassName((Object)this.sizingComponent)).append(" ");
                lsb.append(this.sizingComponent.getHeight()).newline();
            } else {
                lsb.append("override height set at ").append(heightToUse).newline();
            }
            lsb.append("positioning root element at ").append(middleHeight).newline();
            lsb.append("scaled value ").append(scaledMiddleHeight);
            lg.graphics(lsb.toString());
        }
        this.arrangeChildren(rootVisual);
        this.ourDimension.height = (int)((double)childrenHeight * this.scale);
        this.ourDimension.width = (int)(this.scale * (double)this.maxWidthOfAnyElement);
        JViewport viewport = (JViewport)super.getParent();
        viewport.setSize(this.ourDimension);
        this.setPreferredSize(this.ourDimension);
        this.setSize(this.ourDimension);
        if (lg.isGraphicsEnabled()) {
            LineStringBuilder lsb = new LineStringBuilder("size ");
            lsb.write(this.ourDimension.toString());
            lsb.append("parent ");
            lsb.write(this.getParent().getSize().toString());
            lg.graphics(lsb.toString());
        }
        this.revalidate();
        this.repaint();
    }

    private void arrangeChildren(ElementVisual ev) {
        int ourX = ev.getX();
        int ourY = ev.getY();
        int right = ourX + ev.getWidth();
        this.maxWidthOfAnyElement = Math.max(this.maxWidthOfAnyElement, right);
        int totalHeights = 0;
        Collection<ElementVisual> children = ev.getChildren();
        for (ElementVisual child : children) {
            totalHeights += child.getChildrenHeight();
        }
        int nChildren = children.size();
        int y = ourY - (totalHeights += (nChildren - 1) * 10) / 2;
        for (ElementVisual child : children) {
            if (!child.isUserPositioned()) {
                child.setX(ourX + ev.getWidth() + 10);
                child.setY(y + child.getChildrenHeight() / 2);
            }
            y += 10 + child.getChildrenHeight();
        }
        for (ElementVisual child : children) {
            this.arrangeChildren(child);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D twoDee = (Graphics2D)g;
        if (this.chp != null) {
            this.chp.paint(twoDee);
        }
        if (this.root == null) {
            return;
        }
        if (lg.isGraphicsEnabled()) {
            lg.graphics("painting WorkflowCanvas");
        }
        ElementVisual rootVisual = this.getVisual(this.root);
        this.paintNode(twoDee, rootVisual);
    }

    private void paintNode(Graphics2D graphics, ElementVisual ev) {
        ev.paint(graphics);
        for (ElementVisual child : ev.getChildren()) {
            this.paintNode(graphics, child);
            Point start = this.scale(ev.getFlowOut());
            Point end = this.scale(child.getFlowIn());
            graphics.setColor(Color.BLACK);
            if (lg.isGraphicsEnabled()) {
                lg.graphics("drawing connector " + start + " to " + end);
            }
            graphics.drawLine(start.x, start.y, end.x, end.y);
        }
    }

    private class ToolWatcher
    implements InstallationListener {
        private ToolWatcher() {
        }

        public void toolChanged(InstallationEvent event) {
            WorkflowCanvas.this.invalidateAllVisuals();
        }
    }

    private class SizingWindowWatcher
    extends ComponentAdapter {
        private SizingWindowWatcher() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("resize event");
            }
            WorkflowCanvas.this.arrangeElements();
        }
    }

    private class ElementFinder
    implements NodeVisitor {
        int x;
        int y;
        ElementVisual found;

        private ElementFinder() {
        }

        public ElementVisual isAt(int x, int y) {
            this.found = null;
            this.x = x;
            this.y = y;
            if (WorkflowCanvas.this.root != null) {
                WorkflowCanvas.this.root.traverse((NodeVisitor)this);
            }
            return this.found;
        }

        public boolean visit(WorkflowNode node) {
            double adjustedY;
            double adjustedX;
            if (node.getWorkflowElement().isDeletePending()) {
                return false;
            }
            ElementVisual ev = WorkflowCanvas.this.getVisual(node);
            if (ev.inside((int)(adjustedX = (double)this.x / WorkflowCanvas.this.scale - (double)ev.leftX()), (int)(adjustedY = (double)this.y / WorkflowCanvas.this.scale - (double)ev.topY()))) {
                this.found = ev;
                return false;
            }
            return true;
        }
    }

    private class MouseProcessor
    extends MouseInputAdapter {
        private MouseProcessor() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            boolean multipleClicked;
            if (lg.isGraphicsEnabled()) {
                lg.graphics("Workflow canvas mouseClicked " + e);
            }
            int x = e.getX();
            int y = e.getY();
            ElementVisual clicked = WorkflowCanvas.this.elementFinder.isAt(x, y);
            boolean multipleSelect = e.isControlDown();
            boolean bl = multipleClicked = e.getClickCount() > 1;
            if (lg.isGraphicsEnabled()) {
                lg.graphics("Clicked element " + clicked + " with control " + multipleSelect);
            }
            if (WorkflowCanvas.this.selected.size() == 0) {
                multipleSelect = false;
            }
            if (clicked == null) {
                if (!multipleSelect) {
                    for (ElementVisual ev : WorkflowCanvas.this.selected) {
                        ev.setSelected(false);
                    }
                    WorkflowCanvas.this.selected.clear();
                    WorkflowCanvas.this.client.selectionCleared();
                }
                if (multipleClicked && WorkflowCanvas.this.root != null) {
                    WorkflowCanvas.this.openWorkflowEditor();
                }
                return;
            }
            clicked.setSelected(true);
            boolean selectionChanged = true;
            if (WorkflowCanvas.this.selected.contains(clicked) && (WorkflowCanvas.this.selected.size() == 1 || multipleSelect)) {
                selectionChanged = false;
            }
            if (selectionChanged) {
                if (multipleSelect) {
                    WorkflowCanvas.this.selected.add(clicked);
                    boolean allSame = true;
                    Iterator iter = WorkflowCanvas.this.selected.iterator();
                    assert (iter.hasNext());
                    ElementVisual first = (ElementVisual)iter.next();
                    while (iter.hasNext() && allSame) {
                        if (first.nodeTypeSameAs((ElementVisual)iter.next())) continue;
                        allSame = false;
                    }
                    clicked.notifyClient(WorkflowCanvas.this.client, allSame, false);
                } else {
                    for (ElementVisual ev : WorkflowCanvas.this.selected) {
                        ev.setSelected(false);
                    }
                    WorkflowCanvas.this.selected.clear();
                    WorkflowCanvas.this.selected.add(clicked);
                    clicked.notifyClient(WorkflowCanvas.this.client, true, true);
                }
            }
            if (e.getClickCount() > 1) {
                if (WorkflowCanvas.this.lastEntered != null) {
                    WorkflowCanvas.this.lastEntered.mouseLeft();
                }
                JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(Frame.class, WorkflowCanvas.this);
                clicked.doubleClicked(owner, x, y);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("Workflow canvas mouseEntered " + e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("Workflow canvas mouseExited " + e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("Workflow canvas mousePressed " + e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (lg.isGraphicsEnabled()) {
                lg.graphics("Workflow canvas mouseReleased " + e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (WorkflowCanvas.this.portfolioViewer != null && WorkflowCanvas.this.portfolioViewer.isVisible()) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            ElementVisual entered = WorkflowCanvas.this.elementFinder.isAt(x, y);
            if (entered == WorkflowCanvas.this.lastEntered) {
                return;
            }
            if (WorkflowCanvas.this.lastEntered != null) {
                WorkflowCanvas.this.lastEntered.mouseLeft();
            }
            WorkflowCanvas.this.lastEntered = entered;
            if (entered != null) {
                entered.mouseEntered(e);
            }
        }
    }

    public static interface CanvasClient {
        public void actorElementSelected(NodeForActor var1, boolean var2, boolean var3);

        public void portfolioSelected(NodeForPortfolio var1, boolean var2, boolean var3);

        public void selectionCleared();

        public void clearWorkflow();
    }
}

