/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui;

import edu.uchc.connjur.wb.Workflow;
import edu.uchc.connjur.wb.gui.GraphicLogger;
import edu.uchc.connjur.wb.gui.GuiUtil;
import edu.uchc.connjur.wb.gui.WorkflowCanvas;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WorkflowEditor
extends JDialog {
    public static final int DEFAULT_MIN_WIDTH = 500;
    public static final int DEFAULT_ELEMENT_COLS = 20;
    private Workflow workflow;
    private JLabel idLabel;
    private JTextField userField;
    private JButton deleteButton;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel buttonPanel;
    private JTextArea notesArea;
    private JTextArea keywordsArea;
    private JPanel gridPanel;
    private JLabel dateLastUsed;
    private JLabel dateCreated;
    private JTextField entityField;
    private WorkflowCanvas.CanvasClient canvasClient;
    private static final GraphicLogger lg = GraphicLogger.getLogger(WorkflowEditor.class);

    public WorkflowEditor(Frame frame, WorkflowCanvas.CanvasClient client) {
        super(frame, "Workflow", true);
        this.canvasClient = client;
        this.initGUI();
        GraphicsConfiguration ge = frame.getGraphicsConfiguration();
        Rectangle bounds = ge.getBounds();
        int width = Math.max(bounds.width / 2, 500);
        this.pack();
        this.setSize(width, this.getHeight());
        this.setLocationRelativeTo(frame);
        if (lg.isGraphicsEnabled()) {
            lg.graphics("WorkflowEditor  " + this.getSize());
        }
    }

    private void initGUI() {
        BoxLayout thisLayout = new BoxLayout(this.getContentPane(), 1);
        this.getContentPane().setLayout(thisLayout);
        JPanel spacer = new JPanel();
        this.getContentPane().add(spacer);
        this.gridPanel = new JPanel();
        spacer.add(this.gridPanel);
        GridLayout gridPanelLayout = new GridLayout(0, 2);
        gridPanelLayout.setHgap(5);
        gridPanelLayout.setVgap(5);
        this.gridPanel.setLayout(gridPanelLayout);
        this.gridPanel.add(new JLabel("ID:"));
        this.idLabel = new JLabel(" ");
        this.gridPanel.add(this.idLabel);
        this.gridPanel.add(new JLabel("User:"));
        this.userField = this.addField("NMR", 20);
        this.gridPanel.add(new JLabel("Entity:"));
        this.entityField = this.addField("protein", 20);
        this.gridPanel.add(new JLabel("Date created:"));
        this.dateCreated = new JLabel("1/1/1970");
        this.gridPanel.add(this.dateCreated);
        this.gridPanel.add(new JLabel("Date last used:"));
        this.dateLastUsed = new JLabel("today");
        this.gridPanel.add(this.dateLastUsed);
        this.notesArea = new JTextArea(6, 20);
        this.getContentPane().add(this.getNotePanel("Notes", this.notesArea));
        this.keywordsArea = new JTextArea(6, 20);
        this.getContentPane().add(this.getNotePanel("Keywords", this.keywordsArea));
        this.buttonPanel = new JPanel();
        this.getContentPane().add(this.buttonPanel);
        this.okButton = new JButton();
        this.buttonPanel.add(this.okButton);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton = new JButton();
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.deleteButton = new JButton();
        this.buttonPanel.add(this.deleteButton);
        this.deleteButton.setText("Delete this workflow");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkflowEditor.this.deleteButtonActionPerformed(evt);
            }
        });
        this.pack();
    }

    private JTextField addField(String demo, int columns) {
        JTextField jtf = new JTextField(demo, columns);
        this.gridPanel.add(jtf);
        return jtf;
    }

    private JPanel getNotePanel(String label, JTextArea textArea) {
        JPanel panel = new JPanel();
        BoxLayout panelLayout = new BoxLayout(panel, 1);
        panel.setLayout(panelLayout);
        panel.add(new JLabel(label));
        JScrollPane jScrollPane1 = new JScrollPane();
        panel.add(jScrollPane1);
        jScrollPane1.setViewportView(textArea);
        return panel;
    }

    public void setWorkflow(Workflow workflow) {
        assert (workflow != null);
        this.workflow = workflow;
        this.idLabel.setText(GuiUtil.text(workflow.getId()));
        String user = workflow.getUser();
        if (user == null) {
            user = System.getProperty("user.name");
        }
        this.userField.setText(user);
        this.entityField.setText(GuiUtil.text(workflow.getEntity()));
        this.notesArea.setText(GuiUtil.text(workflow.getNotes()));
        this.keywordsArea.setText(GuiUtil.text(workflow.getKeywords()));
        this.dateCreated.setText(GuiUtil.dateString(workflow.getCreated()));
        this.dateLastUsed.setText(GuiUtil.dateString(workflow.getLastUsed()));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        super.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.workflow.setUser(this.userField.getText());
        this.workflow.setEntity(this.entityField.getText());
        this.workflow.setNotes(this.notesArea.getText());
        this.workflow.setKeywords(this.keywordsArea.getText());
        this.workflow.setLastUsed(new Date());
        super.setVisible(false);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int rc = JOptionPane.showConfirmDialog(this, "Do you wish to delete " + this.workflow.describe() + "?", "Confirm Delete", 0);
        if (rc == 0) {
            this.workflow.delete();
            this.canvasClient.clearWorkflow();
            this.setVisible(false);
        }
    }
}

