/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.actor;

import edu.uchc.connjur.core.UserNotifier;
import edu.uchc.connjur.spectrumtranslator.CodeUtil;
import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.DataElement;
import edu.uchc.connjur.wb.ExecutionTrace;
import edu.uchc.connjur.wb.UniformDataElement;
import edu.uchc.connjur.wb.WorkflowBuilderProcessingException;
import edu.uchc.connjur.wb.actor.DisplayActor;
import edu.uchc.connjur.wb.actor.FlowActor;
import edu.uchc.connjur.wb.actor.PipeActor;
import edu.uchc.connjur.wb.actor.ReceiverThread;
import edu.uchc.connjur.wb.annotation.ConfigBoolean;
import edu.uchc.connjur.wb.annotation.FlaggedConfigAttributes;
import edu.uchc.connjur.wb.annotation.Flags;
import edu.uchc.connjur.wb.context.ExecutionContext;
import edu.uchc.connjur.wb.context.Installation;
import edu.uchc.connjur.wb.context.InstallationContext;
import edu.uchc.connjur.wb.context.PlaceholderContext;
import edu.uchc.connjur.wb.context.ProcessingContext;
import edu.uchc.connjur.wb.event.ActorEvent;
import edu.uchc.connjur.wb.nmrpipe.NMRPipeProcessor;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class DisplayNMRDraw
extends FlowActor
implements DisplayActor,
FlaggedConfigAttributes {
    public static String TEMP_FILE_PREFIX = "ConnjurNMRDrawInput";
    public static String TEMP_FILE_SUFFIX = "pipe";
    @ConfigBoolean
    boolean displayWhenRun = false;
    @ConfigBoolean
    boolean waitForClose = false;
    @ConfigBoolean(flags=@Flags(value=65L))
    boolean displayNow = false;
    private boolean commandDisplay = false;
    private static String executable = null;
    private UniformDataElement data;

    public DisplayNMRDraw() {
        this.setProcessState(Actor.ProcessState.WAITING_START);
    }

    public boolean isToolInstalled() {
        Installation context = Installation.getInstance();
        return context.isToolSupported(InstallationContext.Tool.NMRDRAW, NMRPipeProcessor.PIPE_MAJOR_TESTED, NMRPipeProcessor.PIPE_MINOR_TESTED);
    }

    public void acceptInput(DataElement dataElement) {
        this.data = (UniformDataElement)dataElement;
    }

    public void connect(DataElement input, DataElement output) {
        this.data = (UniformDataElement)input;
        assert (output == null);
    }

    public Actor.CanProcess canProcess(ProcessingContext context) {
        return Actor.CanProcess.SUPPORTED;
    }

    public String getDescription() {
        return "NMRDraw display";
    }

    public void subExecute(ExecutionContext ctx) throws Exception {
        String[] baseCommands;
        if (!this.commandDisplay && !this.displayWhenRun) {
            return;
        }
        if (executable == null) {
            Installation context = Installation.getInstance();
            executable = context.pathTo(InstallationContext.Tool.NMRDRAW);
        }
        File tempfile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        FileOutputStream fos = new FileOutputStream(tempfile);
        NMRPipeProcessor.genPipe((UniformDataElement)this.data, (int)1, (OutputStream)fos);
        ArrayList<String> cmdArray = new ArrayList<String>();
        cmdArray.add(executable);
        for (String s : baseCommands = new String[]{"-frp", "1", "-size"}) {
            cmdArray.add(s);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle r = ge.getMaximumWindowBounds();
        cmdArray.add(Integer.toString(r.width));
        cmdArray.add(Integer.toString(r.height));
        cmdArray.add("-in");
        cmdArray.add(tempfile.getAbsolutePath());
        String[] cmds = cmdArray.toArray(baseCommands);
        String cmdString = null;
        if (lg.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(ExecutionTrace.ident((Object)((Object)this)));
            sb.append(" executing commands: ");
            for (String s : cmds) {
                sb.append('\'');
                sb.append(s);
                sb.append("' ");
            }
            cmdString = sb.toString();
            lg.info((Object)cmdString);
        }
        Process p = Runtime.getRuntime().exec(cmds);
        p.getOutputStream().close();
        if (this.waitForClose) {
            ReceiverThread errReader = new ReceiverThread(p.getErrorStream());
            ReceiverThread outReader = new ReceiverThread(p.getInputStream());
            outReader.start();
            errReader.start();
            p.waitFor();
            outReader.join();
            errReader.join();
            if (lg.isInfoEnabled()) {
                lg.info((Object)(cmdString + " messages:" + CodeUtil.NEWLINE + errReader.getOutput()));
                lg.info((Object)(cmdString + " output:" + CodeUtil.NEWLINE + outReader.getOutput()));
            }
            PipeActor.rethrowIfNotNull((Exception)outReader.getCaught());
            PipeActor.rethrowIfNotNull((Exception)errReader.getCaught());
            if (p.exitValue() != 0) {
                throw new RuntimeException("Exit code " + p.exitValue());
            }
        }
    }

    public DataElement getResult() {
        return null;
    }

    public boolean isDisplayWhenRun() {
        return this.displayWhenRun;
    }

    public void setDisplayWhenRun(boolean displayWhenRun) {
        this.displayWhenRun = displayWhenRun;
    }

    public boolean isDisplayNow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayNow(boolean displayNow) {
        if (displayNow) {
            if (!this.isToolInstalled()) {
                throw new WorkflowBuilderProcessingException("NMRDraw not installed");
            }
            if (this.data.isMetaDataOnly() || this.data.isVirtual()) {
                UserNotifier.getInstance().tellUser("Data not currently viewable");
                this.notifyListeners(ActorEvent.Reason.CONFIG_CHANGE);
                return;
            }
            try {
                this.commandDisplay = true;
                this.execute((ExecutionContext)new PlaceholderContext());
            }
            finally {
                this.commandDisplay = false;
            }
        }
    }

    public boolean isWaitForClose() {
        return this.waitForClose;
    }

    public void setWaitForClose(boolean waitForClose) {
        this.waitForClose = waitForClose;
    }
}

