/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.core.utility.Versions;
import edu.uchc.connjur.spectrumtranslator.Converter;
import edu.uchc.connjur.wb.Actor;
import edu.uchc.connjur.wb.LineStringBuilder;
import edu.uchc.connjur.wb.Workflow;
import edu.uchc.connjur.wb.context.Installation;
import edu.uchc.connjur.wb.dataaccess.Factory;
import edu.uchc.connjur.wb.gui.GuiUtil;
import edu.uchc.connjur.wb.gui.component.Credits;
import edu.uchc.connjur.wb.gui.component.LicenseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class About
extends JDialog {
    private JTextArea versionArea;
    private JButton licenseButton;
    private JPanel mainPanel;
    private JButton credits;
    private JPanel buttonPanel;
    private JButton closeButton;

    public About(Frame owner) {
        super(owner, "About WorkflowBuilder");
        this.initGUI();
        LineStringBuilder sb = new LineStringBuilder();
        sb.write("Workflow Builder");
        sb.append("Spectrum Translator version ");
        sb.append(Converter.getVersion());
        sb.append(" built ");
        sb.write(Converter.buildDate());
        Properties wb = Versions.versionProperties((ClassLoader)Actor.class.getClassLoader(), (String)"libworkflowbuilder");
        sb.append("Workflow Builder library version ");
        sb.append(Versions.getVersion((Properties)wb));
        sb.append(" built ");
        sb.write(Versions.buildDate((Properties)wb));
        Properties itf = Versions.versionProperties((ClassLoader)About.class.getClassLoader(), (String)"interfaceworkflowbuilder");
        sb.append("Workflow Builder interface version ");
        sb.append(Versions.getVersion((Properties)itf));
        sb.append(" built ");
        sb.write(Versions.buildDate((Properties)itf));
        sb.append("Database: ");
        sb.write(Factory.get().identify());
        sb.write("Available tools:");
        Collection tools = Installation.getInstance().getAvailableTools();
        for (String tool : tools) {
            sb.append("  ");
            sb.write(tool);
        }
        this.versionArea.setText(sb.toString());
        Dimension size = this.getPreferredSize();
        size.height += 20;
        this.setSize(size);
    }

    private void initGUI() {
        try {
            this.versionArea = new JTextArea();
            this.getContentPane().add((Component)this.versionArea, "Center");
            this.versionArea.setText("WorkflowBuilder");
            this.versionArea.setEditable(false);
            this.mainPanel = new JPanel();
            this.getContentPane().add((Component)this.mainPanel, "South");
            this.buttonPanel = new JPanel();
            this.mainPanel.add(this.buttonPanel);
            this.credits = new JButton();
            this.buttonPanel.add(this.credits);
            this.credits.setText("Credits");
            this.credits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    About.this.creditsActionPerformed(evt);
                }
            });
            this.licenseButton = new JButton();
            this.buttonPanel.add(this.licenseButton);
            this.licenseButton.setText("License");
            this.licenseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    About.this.licenseButtonActionPerformed(evt);
                }
            });
            this.closeButton = new JButton();
            this.buttonPanel.add(this.closeButton);
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    About.this.closeButtonActionPerformed();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private void creditsActionPerformed(ActionEvent evt) {
        Credits credits = new Credits(30);
        credits.run();
        credits.appendText(" ", 72);
        this.addBlock(credits, "Early contributors to concepts later incorporated into WorkflowBuilder\nSusan Fox-Erlich\nRick Giorgio\nVal Gorbatyuk \nGary Klesczewski\nTim Martyn\nRob Raupach \nDamon Rosenthal\nGeorge Rypysc", 10);
        credits.appendText(" ", 72);
        String thanks = GuiUtil.readResourceFile(Workflow.class, "technicalthanks.txt");
        this.addBlock(credits, thanks, 10);
        credits.appendText(" ", 72);
        credits.appendText("CONNJUR Workflow Builder", 36);
        credits.appendText(" ", 36);
        credits.appendText("Screenplay by: Jay Vyas", 22);
        credits.appendText("University of Connecticut", 22);
        credits.appendText(" ", 72);
        credits.appendText("Set Design: RJ Nowling", 22);
        credits.appendText("University of Connecticut", 22);
        credits.appendText(" ", 72);
        credits.appendText("Costume Design: Matt Fenwick", 22);
        credits.appendText("University of Connecticut", 22);
        credits.appendText(" ", 72);
        credits.appendText("Executive Producer: Dr. Heidi Ellis", 22);
        credits.appendText("Western New England College", 22);
        credits.appendText(" ", 72);
        credits.appendText("Executive Producer: Dr. Michael Gryk", 22);
        credits.appendText("University of Connecticut", 22);
        credits.appendText(" ", 72);
        credits.appendText("Directed by: Gerard Weatherby", 22);
        credits.appendText("Western New England College", 22);
        credits.appendText(" ", 140);
        credits.finish(1000, 3000);
    }

    private void addBlock(Credits credits, String block, int size) {
        String[] lines;
        for (String line : lines = block.split("\n")) {
            credits.appendText(line, size);
        }
    }

    private void licenseButtonActionPerformed(ActionEvent evt) {
        Frame owner = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        LicenseDialog ld = new LicenseDialog(owner);
        ld.setVisible(true);
    }
}

