/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.wb.NodeForActor;
import edu.uchc.connjur.wb.NodeForLoader;
import edu.uchc.connjur.wb.NodeForPortfolio;
import edu.uchc.connjur.wb.Workflow;
import edu.uchc.connjur.wb.WorkflowNode;
import edu.uchc.connjur.wb.gui.WorkflowCanvas;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class CanvasHelpPainter
implements WorkflowCanvas.CanvasClient {
    private WorkflowCanvas canvas;
    private List<String> helpList = new ArrayList<String>();

    public CanvasHelpPainter(WorkflowCanvas canvas) {
        this.canvas = canvas;
        this.startupMessage();
    }

    public void paint(Graphics2D g) {
        FontMetrics f = g.getFontMetrics();
        int height = f.getHeight();
        int row = 1;
        for (String line : this.helpList) {
            g.drawString(line, 2, height * row++);
        }
    }

    private boolean title() {
        this.helpList.clear();
        WorkflowNode r = this.canvas.getRoot();
        if (r == null) {
            this.startupMessage();
            return false;
        }
        Workflow w = r.getWorkflow();
        StringBuilder sb = new StringBuilder();
        Integer workflowId = w.getId();
        if (workflowId == null) {
            sb.append("Unsaved Workflow");
        } else {
            sb.append("Workflow id ");
            sb.append(workflowId);
        }
        sb.append(" User: ");
        sb.append(w.getUser());
        String entity = w.getEntity();
        if (entity != null && entity.trim().length() > 0) {
            sb.append(" Entity: ");
            sb.append(entity);
        }
        this.helpList.add(sb.toString());
        if (w.isCanRun()) {
            this.helpList.add("Click Run button on the toolbar to execute Actors");
        }
        return true;
    }

    private void generic() {
        if (this.title()) {
            this.helpList.add("Click on Actors (diamonds, triangles, and circles) to configure");
            this.helpList.add("Click on Portfolios (rectangles) to view information about data");
            this.helpList.add("Double click anywhere on back screen to edit Workflow information");
        }
    }

    @Override
    public void actorElementSelected(NodeForActor node, boolean exclusive, boolean single) {
        if (!(node instanceof NodeForLoader)) {
            if (single) {
                if (this.title()) {
                    this.helpList.add("Double click on Actor to configure");
                    this.helpList.add("Hold the meta key down to select additional actors");
                }
            } else if (exclusive) {
                this.title();
                this.helpList.add("One or more actors in a single strand may be copied or cut");
            } else {
                this.generic();
            }
        } else {
            this.title();
            this.helpList.add("Double click on Importer (triangle) to select file or directory to load");
        }
    }

    @Override
    public void portfolioSelected(NodeForPortfolio node, boolean exclusive, boolean single) {
        if (single) {
            this.title();
            this.helpList.add("Double click on Portfolio (rectangle) to view information about data");
            this.helpList.add("Additional Actors and Strands may be added from the toolbar");
        } else {
            this.generic();
        }
    }

    @Override
    public void selectionCleared() {
        this.generic();
    }

    @Override
    public void clearWorkflow() {
        this.startupMessage();
    }

    private void startupMessage() {
        this.helpList.add("Select File->New to create new Workflow by importing data from file system.");
        this.helpList.add("Select File->Open to open Workflow previously saved in database.");
    }
}

