/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.wb.gui.ColorCatalog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorPanel
extends JPanel {
    private static int SAMPLE_WIDTH = 100;
    JLabel label;
    private JButton changeButton;
    private JPanel samplePanel;
    private ColorCatalog.Item item;
    private static JColorChooser chooser = new JColorChooser();
    private static ColorCatalog catalog = ColorCatalog.get();

    private void initGUI() {
        try {
            this.label = new JLabel();
            this.add(this.label);
            this.samplePanel = new JPanel();
            this.add(this.samplePanel);
            this.changeButton = new JButton();
            this.add(this.changeButton);
            this.changeButton.setText("Change");
            this.changeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ColorPanel.this.changeButtonActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ColorPanel(ColorCatalog.Item item) {
        this.initGUI();
        this.item = item;
        Dimension d = this.samplePanel.getPreferredSize();
        d.width = SAMPLE_WIDTH;
        this.samplePanel.setPreferredSize(d);
        this.label.setText(item.description);
        this.setSampleColor();
    }

    public void setSampleColor() {
        Color c = catalog.get(this.item);
        this.samplePanel.setBackground(c);
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        Color c = catalog.get(this.item);
        chooser.setColor(c);
        JDialog dialog = JColorChooser.createDialog(this, this.item.description + " Color", true, chooser, new ChangeItem(), null);
        dialog.setVisible(true);
    }

    private void setColor() {
        catalog.setPreference(this.item, chooser.getColor());
        this.setSampleColor();
    }

    private class ChangeItem
    implements ActionListener {
        private ChangeItem() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorPanel.this.setColor();
        }
    }
}

