/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.wb.gui.ColorCatalog;
import edu.uchc.connjur.wb.gui.component.ColorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ColorPreferences
extends JDialog {
    public final int HORIZONTAL_MARGIN = 25;
    public final int VERTICAL_MARGIN = 40;
    private JPanel chooserPanel;
    private JButton closeButton;
    private JButton restoreButton;
    private JPanel buttonPanel;
    private ColorPanel[] panels;

    private void initGUI() {
        try {
            this.chooserPanel = new JPanel();
            BoxLayout chooserPanelLayout = new BoxLayout(this.chooserPanel, 1);
            this.chooserPanel.setLayout(chooserPanelLayout);
            this.getContentPane().add((Component)this.chooserPanel, "Center");
            this.buttonPanel = new JPanel();
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.restoreButton = new JButton();
            this.buttonPanel.add(this.restoreButton);
            this.restoreButton.setText("Restore Default Colors");
            this.restoreButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ColorPreferences.this.restoreButtonActionPerformed(evt);
                }
            });
            this.closeButton = new JButton();
            this.buttonPanel.add(this.closeButton);
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ColorPreferences.this.closeButtonActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ColorPreferences(Frame owner) {
        super(owner, "Color Preferences", true);
        this.initGUI();
        ColorCatalog.Item[] items = ColorCatalog.Item.values();
        this.panels = new ColorPanel[items.length];
        for (int i = 0; i < items.length; ++i) {
            ColorPanel cp;
            this.panels[i] = cp = new ColorPanel(items[i]);
            this.chooserPanel.add(cp);
        }
        int labelWidth = 0;
        int colorPanelWidth = 0;
        for (ColorPanel cp : this.panels) {
            labelWidth = Math.max(labelWidth, cp.label.getPreferredSize().width);
        }
        for (ColorPanel cp : this.panels) {
            Dimension d = cp.label.getPreferredSize();
            d.width = labelWidth;
            cp.label.setPreferredSize(d);
            colorPanelWidth = Math.max(colorPanelWidth, cp.getPreferredSize().width);
        }
        Dimension size = this.getPreferredSize();
        size.height += 40;
        size.width = colorPanelWidth + 25;
        this.setPreferredSize(size);
        this.pack();
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        ColorCatalog.get().restoreDefaults();
        for (ColorPanel cp : this.panels) {
            cp.setSampleColor();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

