/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.wb.gui.ImageFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.Timer;

public class Credits
extends JWindow
implements Runnable {
    private JScrollPane scrollingPane;
    private JButton closeButton;
    private JPanel buttonPanel;
    private JPanel labelPanel;
    private JLabel logoPanel;
    private int targetScroll;
    private JScrollBar vsb;
    private Timer timer;
    private Thread finishThread;
    private int scrollSpeed;

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.getContentPane().setBackground(Color.WHITE);
            this.logoPanel = this.imageLabel();
            this.getContentPane().add((Component)this.logoPanel, "North");
            this.scrollingPane = new JScrollPane();
            this.getContentPane().add((Component)this.scrollingPane, "Center");
            this.scrollingPane.setPreferredSize(new Dimension(600, 300));
            this.scrollingPane.setVerticalScrollBarPolicy(21);
            this.scrollingPane.setHorizontalScrollBarPolicy(31);
            this.labelPanel = new JPanel();
            this.labelPanel.setBackground(Color.WHITE);
            BoxLayout jPanel1Layout = new BoxLayout(this.labelPanel, 1);
            this.labelPanel.setLayout(jPanel1Layout);
            this.scrollingPane.setViewportView(this.labelPanel);
            this.buttonPanel = new JPanel();
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.buttonPanel.setBackground(Color.WHITE);
            this.closeButton = new JButton();
            this.closeButton.setBackground(Color.WHITE);
            this.closeButton.setBorderPainted(false);
            this.buttonPanel.add(this.closeButton);
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Credits.this.closeButtonActionPerformed(evt);
                }
            });
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension ps = this.getPreferredSize();
            int x = (screen.width - ps.width) / 2;
            int y = (screen.height - ps.height) / 2;
            this.setBounds(x, y, this.getWidth(), this.getHeight());
            this.setAlwaysOnTop(true);
            this.vsb = this.scrollingPane.getVerticalScrollBar();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JLabel imageLabel() {
        Icon img = ImageFactory.get().getLogoIcon();
        return new JLabel(img);
    }

    public Credits(int scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    @Override
    public void run() {
        this.initGUI();
        this.setVisible(true);
        this.repaint();
        this.timer = new Timer(this.scrollSpeed, new Scroller());
        this.timer.start();
    }

    public void finish(final int startPauseMilliseconds, final int endMilliseconds) {
        this.finishThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(startPauseMilliseconds);
                    while (Credits.this.targetScroll > Credits.this.vsb.getValue()) {
                        Thread.sleep(Credits.this.scrollSpeed);
                    }
                    Thread.sleep(endMilliseconds);
                    if (Credits.this.timer != null) {
                        Credits.this.timer.stop();
                        Credits.this.dispose();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.finishThread.start();
    }

    public void setText(String string, int i) {
        this.labelPanel.removeAll();
        this.appendText(string, i);
    }

    public void appendText(String string, int size) {
        JLabel label = new JLabel();
        this.labelPanel.add(label);
        label.setText(string);
        label.setFont(new Font("Dialog", 0, size));
        label.setHorizontalAlignment(0);
        label.setAlignmentX(0.5f);
        this.labelPanel.add(label);
        this.pack();
        int visible = this.vsb.getVisibleAmount();
        int max = this.vsb.getMaximum();
        this.targetScroll = max - visible;
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.finishThread.interrupt();
        this.dispose();
    }

    private class Scroller
    implements ActionListener {
        private Scroller() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int now = Credits.this.vsb.getValue();
            if (now < Credits.this.targetScroll) {
                Credits.this.vsb.setValue(now + 1);
            }
        }
    }
}

