/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.wb.ExecutionTrace;
import edu.uchc.connjur.wb.OutputSinkWriter;
import edu.uchc.connjur.wb.gui.WorkflowBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExceptionDialog
extends JDialog {
    private JLabel messageLabel;
    private JButton buttonSend;
    private JCheckBox checkDetail;
    private JButton exitButton;
    private JPanel buttonPanel;
    private JTextArea detailText;
    private JScrollPane detailScroll;
    private Throwable exception;

    private void initGUI() {
        try {
            this.messageLabel = new JLabel();
            this.messageLabel.setHorizontalAlignment(0);
            this.getContentPane().add((Component)this.messageLabel, "North");
            this.detailScroll = new JScrollPane();
            this.getContentPane().add((Component)this.detailScroll, "Center");
            this.detailText = new JTextArea();
            this.detailText.setEditable(false);
            this.detailScroll.setViewportView(this.detailText);
            this.buttonPanel = new JPanel();
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.checkDetail = new JCheckBox();
            this.buttonPanel.add(this.checkDetail);
            this.checkDetail.setText("Show Detail");
            this.checkDetail.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionDialog.this.showDetail();
                }
            });
            this.buttonSend = new JButton();
            this.buttonPanel.add(this.buttonSend);
            this.buttonSend.setText("Send Error Report");
            this.buttonSend.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ExceptionDialog.this.sendBugReport();
                }
            });
            this.exitButton = new JButton("Close");
            this.buttonPanel.add(this.exitButton);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ExceptionDialog.this.dispose();
                }
            });
        }
        catch (Exception e) {
            System.exit(2);
        }
    }

    public ExceptionDialog(Throwable t, boolean sayNever) {
        this.setDefaultCloseOperation(2);
        this.exception = t;
        this.initGUI();
        this.setModal(true);
        String msg = ExecutionTrace.getRootThrowable((Throwable)t).getMessage();
        if (sayNever) {
            msg = "<html><center>An unexpected error has occurred.<br>While we hope that you never encounter this message, something we hadn't planned on has occurred.<br>We'd appreciate you sending us an error report by pressing " + this.buttonSend.getText() + "<br>" + "You'll be given an opportunity to review the report before it is recorded by the CONNJUR team<br>" + msg + "</html>";
            this.exitButton.setText("Exit");
        }
        this.messageLabel.setText(msg);
        this.detailScroll.setVisible(false);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - this.getWidth()) / 2;
        int y = (screen.height - this.getHeight()) / 2;
        this.setBounds(x, y, this.getWidth(), this.getHeight());
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    private void showDetail() {
        boolean isSelected = this.checkDetail.isSelected();
        this.detailScroll.setVisible(isSelected);
        if (isSelected) {
            OutputSinkWriter osw = new OutputSinkWriter();
            this.exception.printStackTrace((PrintWriter)osw);
            this.detailText.setText(osw.toString());
        }
        this.pack();
    }

    private void sendBugReport() {
        LinkedHashMap<String, String> bsh = new LinkedHashMap<String, String>();
        OutputSinkWriter osw = new OutputSinkWriter();
        this.exception.printStackTrace((PrintWriter)osw);
        bsh.put("exceptionTrace", osw.toString());
        ExceptionDialog.addProp(bsh, "java.vendor");
        ExceptionDialog.addProp(bsh, "java.vendor.url");
        ExceptionDialog.addProp(bsh, "java.version");
        ExceptionDialog.addProp(bsh, "os.arch");
        ExceptionDialog.addProp(bsh, "os.version");
        WorkflowBuilder.openCONNJURPage(this, "exception", bsh);
    }

    private static void addProp(Map<String, String> destination, String propertyName) {
        String value = System.getProperty(propertyName);
        destination.put(propertyName, value);
    }
}

