/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.wb.SingleFid;
import edu.uchc.connjur.wb.gui.ColorCatalog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class FidPanel
extends JPanel {
    private static final long serialVersionUID = -524608115778523533L;
    private SingleFid fid;
    private double verticalScale = 1.0;
    private static ColorCatalog catalog = ColorCatalog.get();
    public static final int WIDTH = 200;
    public static final int HEIGHT = 200;
    public static final int MARGIN = 5;
    public static final Dimension DEFAULT_SIZE = new Dimension(200, 200);

    public FidPanel() {
        super.setSize(DEFAULT_SIZE);
    }

    public void setFid(SingleFid fid, double scale) {
        this.fid = fid;
        float max = Float.MIN_VALUE;
        for (int i = 0; i < fid.getSize(); ++i) {
            float f = Math.abs(fid.getValue(i));
            if (!(f > max)) continue;
            max = f;
        }
        Dimension ourSize = new Dimension(DEFAULT_SIZE);
        ourSize.width = fid.getSize() + 10;
        ourSize.height = (int)((double)ourSize.height * scale);
        ourSize.width = (int)((double)ourSize.width * scale);
        this.setSize(ourSize);
        this.setPreferredSize(ourSize);
        double halfVisualHeight = (ourSize.height - 5) / 2;
        this.verticalScale = halfVisualHeight / (double)max;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        Rectangle b = graphics.getClipBounds();
        graphics.setColor(catalog.get(ColorCatalog.Item.POPUP_BACKGROUND));
        graphics.fillRect(b.x, b.y, b.width, b.height);
        int horizontalCenter = this.getSize().height / 2;
        graphics.setColor(catalog.get(ColorCatalog.Item.POPUP_FOREGROUND));
        for (int i = 0; i < this.fid.getSize(); ++i) {
            float f = this.fid.getValue(i);
            int x = 5 + i;
            int y = horizontalCenter + (int)((double)f * this.verticalScale);
            graphics.drawLine(x, y, x, y);
        }
    }
}

