/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.core.UserNotifier;
import edu.uchc.connjur.wb.gui.ColorCatalog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class RunPopup {
    private static ColorCatalog catalog = ColorCatalog.get();
    public static final int MINIMUM_WIDTH = 400;
    public static final int HEIGHT = 225;
    public static final int MARGIN = 2;
    private Component owner;
    private Client client;
    private RunPanelImpl impl = null;

    public RunPopup(Component owner, Client client) {
        this.owner = owner;
        this.client = client;
    }

    public void show() {
        this.impl = new RunPanelImpl(this.owner);
    }

    public void hide() {
        this.impl.shutdown();
        this.impl = null;
    }

    private class RunPanelImpl
    extends JDialog
    implements UserNotifier.NotificationProtocol,
    Runnable {
        private JTextArea textArea;
        private JScrollPane scrollPane;
        private String message = "\n";
        private int lastNewline = 0;

        public RunPanelImpl(Component owner) {
            JFrame top = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, owner);
            top.addWindowListener(new ActivationWatcher());
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.scrollPane = new JScrollPane();
            this.add((Component)this.scrollPane, "Center");
            this.textArea = new JTextArea();
            this.scrollPane.setViewportView(this.textArea);
            this.textArea.setText(this.message);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            JPanel buttonPanel = new JPanel();
            JButton stopButton = new JButton("Stop");
            stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunPopup.this.client.stop();
                }
            });
            buttonPanel.add(stopButton);
            this.add((Component)buttonPanel, "South");
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            this.textArea.setForeground(catalog.get(ColorCatalog.Item.POPUP_FOREGROUND));
            Color bg = catalog.get(ColorCatalog.Item.POPUP_BACKGROUND);
            this.setBackground(bg);
            this.scrollPane.setBackground(bg);
            this.textArea.setBackground(bg);
            UserNotifier.getInstance().addProtocol((UserNotifier.NotificationProtocol)this);
            this.setLocationRelativeTo(owner);
            this.adjustAndShow();
        }

        private void adjustAndShow() {
            super.setVisible(true);
            Dimension d = this.textArea.getPreferredSize();
            d.height = 225;
            d.width = Math.max(d.width + 2, 400);
            super.setPreferredSize(d);
            super.setSize(d);
            super.pack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RunPanelImpl runPanelImpl = this;
            synchronized (runPanelImpl) {
                this.textArea.setText(this.message);
            }
            this.adjustAndShow();
            JScrollBar vsb = this.scrollPane.getVerticalScrollBar();
            int visible = vsb.getVisibleAmount();
            int max = vsb.getMaximum();
            vsb.setValue(max - visible);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tellUser(String addedMessage) {
            RunPanelImpl runPanelImpl = this;
            synchronized (runPanelImpl) {
                String copy = this.message.substring(0, this.lastNewline + 1);
                this.message = copy = copy + addedMessage;
                this.lastNewline = this.message.lastIndexOf(10);
                if (this.lastNewline == -1) {
                    this.lastNewline = 0;
                }
            }
            SwingUtilities.invokeLater(this);
        }

        public void shutdown() {
            UserNotifier.getInstance().removeProtocol((UserNotifier.NotificationProtocol)this);
            super.setVisible(false);
        }

        private class ActivationWatcher
        extends WindowAdapter {
            private ActivationWatcher() {
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
                RunPanelImpl.this.setAlwaysOnTop(true);
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
                RunPanelImpl.this.setAlwaysOnTop(false);
            }
        }
    }

    public static interface Client {
        public void stop();
    }
}

