/*
 * Decompiled with CFR 0.152.
 */
package edu.uchc.connjur.wb.gui.component;

import edu.uchc.connjur.spectrumtranslator.DimInfo;
import edu.uchc.connjur.spectrumtranslator.DimInfoLabel;
import edu.uchc.connjur.wb.UniformDataElement;
import edu.uchc.connjur.wb.gui.FormatLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class UniformDataElementPanel
extends JPanel {
    private JTable infoTable;
    private JLabel titleLabel;
    private JComboBox formatSelector;
    private FormatModel formatSelectorModel = new FormatModel();
    private JPanel buttonPanel;
    private UniformDataElement dataElement;
    private DisplayTable displayTable = new DisplayTable();
    private DimInfoLabel labelInfo = FormatLabel.CONNJUR.getDimInfoLabel();

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.infoTable = new JTable();
            this.add((Component)this.infoTable, "Center");
            this.infoTable.setModel(this.displayTable);
            this.infoTable.setAutoResizeMode(4);
            this.buttonPanel = new JPanel();
            this.add((Component)this.buttonPanel, "North");
            this.titleLabel = new JLabel();
            this.buttonPanel.add(this.titleLabel);
            this.titleLabel.setText("Label format");
            this.formatSelector = new JComboBox();
            this.buttonPanel.add(this.formatSelector);
            this.formatSelector.setModel(this.formatSelectorModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UniformDataElementPanel() {
        this.initGUI();
        this.formatSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = UniformDataElementPanel.this.formatSelector.getSelectedIndex();
                UniformDataElementPanel.this.labelInfo = UniformDataElementPanel.this.formatSelectorModel.getDimInfoLabel(i);
                UniformDataElementPanel.this.displayTable.fireTableDataChanged();
            }
        });
    }

    public void setDataElement(UniformDataElement dataElement) {
        this.dataElement = dataElement;
        this.displayTable.fireTableStructureChanged();
        this.packColumns(this.infoTable, 2);
    }

    public void packColumns(JTable table, int margin) {
        for (int c = 0; c < table.getColumnCount(); ++c) {
            this.packColumn(table, c, margin);
        }
    }

    public void packColumn(JTable table, int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    private class DisplayTable
    extends AbstractTableModel {
        private DisplayTable() {
        }

        @Override
        public int getColumnCount() {
            if (UniformDataElementPanel.this.dataElement == null) {
                return 0;
            }
            return UniformDataElementPanel.this.dataElement.getNumberAxes();
        }

        @Override
        public int getRowCount() {
            return 13;
        }

        @Override
        public Object getValueAt(int row, int column) {
            assert (UniformDataElementPanel.this.dataElement != null);
            return this.info(row, UniformDataElementPanel.this.dataElement.getDataByDim(column));
        }

        private String info(int row, DimInfo di) {
            int dim = di.getDimension();
            switch (row) {
                case 0: {
                    return UniformDataElementPanel.this.labelInfo.getAxisLabel(dim);
                }
                case 1: {
                    return this.format("Size", di.getSize().toString());
                }
                case 2: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getDataMode(dim), di.getDataMode().toString());
                }
                case 3: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getAnalysisDomain(dim), di.getAnalysisDomain().toString());
                }
                case 4: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getName(dim), di.getName());
                }
                case 5: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getSweepWidth(dim), di.getSweepWidth(), 0);
                }
                case 6: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getCarrierPPM(dim), di.getCarrierPPM(), 3);
                }
                case 7: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getSpectralFrequency(dim), di.getSpectralFrequency(), 1);
                }
                case 8: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getZeroOrderPhase(dim), Float.valueOf(di.getZeroOrderPhase()), 2);
                }
                case 9: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getFirstOrderPhase(dim), Float.valueOf(di.getFirstOrderPhase()), 2);
                }
                case 10: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getNegateImaginaries(dim), Boolean.toString(di.isNegateImaginaries()));
                }
                case 11: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getSignAlternation(dim), Boolean.toString(di.isSignAlternation()));
                }
                case 12: {
                    return this.format(UniformDataElementPanel.this.labelInfo.getFirstScalePoint(dim), Float.valueOf(di.getFirstScalePoint()), 0);
                }
            }
            return "";
        }

        private String format(String label, String value) {
            if (label == null) {
                label = "";
            }
            assert (value != null);
            return label + ": " + value;
        }

        private String format(String label, Float value, int decimals) {
            if (label == null) {
                label = "";
            }
            if (value == null) {
                return label + ":";
            }
            String formatString = "%s:  %." + decimals + "f";
            return String.format(formatString, label, value);
        }
    }

    private class FormatModel
    extends AbstractListModel
    implements ComboBoxModel {
        FormatLabel[] formats = FormatLabel.values();
        Object selected = FormatLabel.CONNJUR;

        private FormatModel() {
        }

        @Override
        public Object getElementAt(int i) {
            return this.formats[i].getDimInfoLabel().getDisplayName();
        }

        @Override
        public int getSize() {
            return this.formats.length;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object o) {
            this.selected = o;
        }

        public DimInfoLabel getDimInfoLabel(int i) {
            return this.formats[i].getDimInfoLabel();
        }
    }
}

